/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    http://www.travis-analyzer.de/

    Copyright (c) 2009-2013 Martin Brehm
                  2012-2013 Martin Thomas

    This file written by Martin Brehm.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/

#ifndef RESP_H
#define RESP_H


#include "xobject.h"
#include "timestep.h"
#include "xfloatarray.h"


class CResp : public CxObject
{
public:
	bool m_bNewCP2k;
	void ReadCoord(FILE *a, int mol);
	void WriteMol2(const char *s);
	void RunResp1(int mol);
	void RunResp2(int mol);
	void WriteRespCharges(const char *s);
	void CalcRespSum(int mol);
	bool ReadRespCharges(const char *s, int mol);
	CxFloatArray m_faCharges;
	CResp();
	~CResp();

	void RunGeoOpt(int mol);
	CTimeStep* m_pTimeStep;
//	void ScanNeedBox();
	void PrepareGeoOpt(int mol);
	char* m_sCP2kCommand;
	void ParseResp();
	void PrepareResp_Stage1(int mol);
	void PrepareResp_Stage2(int mol);
	bool m_bGeoOpt;
	bool m_b1stPass;
	bool m_b2ndPass;
	int m_iRAM;
	bool m_bReviewInput;
	bool m_bEachMol;

	int *m_iCharge;
	float *m_fScaleCharge;
	float *m_fNeedBoxX, *m_fNeedBoxY, *m_fNeedBoxZ;
	float *m_fRespSum;

	char m_sBasisFile[256];
	char m_sPotFile[256];
	char m_sTCG[256];
	char m_sBasis[256];
	char m_sGeoBasis[256];
	char m_sGeoBasisFile[256];
};

#endif
