/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    http://www.travis-analyzer.de/

    Copyright (c) 2009-2013 Martin Brehm
                  2012-2013 Martin Thomas

    This file written by Martin Brehm.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/

#ifndef THERMO_H
#define THERMO_H

#include "xobject.h"
#include "xobarray.h"
#include "timestep.h"


class CThermoGroup : public CxObject
{
public:
	CThermoGroup();
	~CThermoGroup();
};


class CThermoAnalysis : public CxObject
{
public:
	void Create();
	void AnalyzeStep(CTimeStep *t);
	CxObArray m_oaThermoGroups;
	void Parse();
	CThermoAnalysis();
	~CThermoAnalysis();

	FILE *m_fEner, *m_fTemp;
};


#endif

