#!/usr/bin/env python

#****************************************************************************
# icondict.py, provides a class to load and store tree icons
#
# TreeLine, an information storage program
# Copyright (C) 2005, Douglas W. Bell
#
# This is free software; you can redistribute it and/or modify it under the
# terms of the GNU General Public License, Version 2.  This program is
# distributed in the hope that it will be useful, but WITTHOUT ANY WARRANTY.
#*****************************************************************************

import globalref
import os.path
from qt import QPixmap

class IconDict(dict):
    """Loads and stores icons by name,
       iconPath should be set in loadIcons() at least once"""
    iconPath = ''
    iconExt = '.png'
    defaultName = 'default'
    noneName = 'NoIcon'
    def __init__(self, initDict={}):
        dict.__init__(self, initDict)
        self[IconDict.noneName] = None

    def loadIcons(self, iconList, iconPathList=[]):
        """Load icons from name list, set iconPath if given"""
        if iconPathList:
            self.setIconPath(iconList[0], iconPathList)
        for iconName in iconList:
            self.loadIcon(iconName)

    def setIconPath(self, iconName, iconPathList):
        """Set icon path to first path where iconName is found"""
        fileName = iconName + IconDict.iconExt
        for path in iconPathList:
            if path and os.access(os.path.join(path, fileName), os.R_OK):
                IconDict.iconPath = path
                return

    def loadIcon(self, iconName):
        """Load icon from iconPath, add to dictionary and return the icon"""
        path = os.path.join(IconDict.iconPath, iconName + IconDict.iconExt)
        pixmap = QPixmap(path)
        if not pixmap.isNull():
            self[iconName] = pixmap
            return pixmap
        return None

    def getIcon(self, name):
        """Return an icon matching name or the default icon"""
        try:
            return self[name]
        except KeyError:
            icon = self.loadIcon(name)
            if not icon and name != IconDict.defaultName:
                icon = self.getIcon(IconDict.defaultName)
            return icon
