/*@HEADER
// ***********************************************************************
// 
//        AztecOO: An Object-Oriented Aztec Linear Solver Package 
//                 Copyright (2002) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//  
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
// Questions? Contact Michael A. Heroux (maherou@sandia.gov) 
// 
// ***********************************************************************
//@HEADER
*/

/*====================================================================
 * ------------------------
 * | CVS File Information |
 * ------------------------
 *
 * $RCSfile: md_timer_generic.c,v $
 *
 * $Author: william $
 *
 * $Date: 2007/01/15 22:59:05 $
 *
 * $Revision: 1.5 $
 *
 * $Name: trilinos-release-9-0-branch $
 *====================================================================*/

#include <time.h>

extern double machine_dependent_second(void);
double machine_dependent_second(void)

  /*
  *    Returns system cpu and wall clock time in seconds. This
  *    is a strictly Ansi C timer, since clock() is defined as an
  *    Ansi C function. On some machines clock() returns type
  *    unsigned long (HP) and on others (SUN) it returns type long.
  *       An attempt to recover the actual time for clocks which have
  *    rolled over is made also. However, it only works if this 
  *    function is called fairly regularily during
  *    the solution procedure.
  *
  *    clock() -> returns the time in microseconds. Division by
  *               the macro CLOCKS_PER_SEC recovers the time in seconds.
  */

{
  static clock_t last_num_ticks = 0;
  static double  inv_clocks_per_sec = 1./(double)CLOCKS_PER_SEC;
  static double  clock_width =
    (double)(1L<<((int)sizeof(clock_t)*8-2))*4./(double)CLOCKS_PER_SEC;
  static int     clock_rollovers = 0;
  double value;
  clock_t num_ticks = clock();
  if(num_ticks < last_num_ticks) clock_rollovers++;
  value = num_ticks * inv_clocks_per_sec;
  if(clock_rollovers) value += clock_rollovers * clock_width;
  last_num_ticks = num_ticks;
  return(value);
}
