// @HEADER
// ***********************************************************************
// 
// Moocho: Multi-functional Object-Oriented arCHitecture for Optimization
//                  Copyright (2003) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//  
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
// Questions? Contact Roscoe A. Bartlett (rabartl@sandia.gov) 
// 
// ***********************************************************************
// @HEADER
//

#if !defined CHECK_CONVERGENCE_STD_STRATEGY_H
#define CHECK_CONVERGENCE_STD_STRATEGY_H

#include "MoochoPack_CheckConvergence_Strategy.hpp"

namespace MoochoPack {

/** \brief Implementation of CheckConvergence_Strategy interface
 *
 * This object can not change the flow of control or do anything fancy.  It just
 *  checks convergence by calculating norm errors and comparing with tolerance
 *  It can update iteration quantities if desired.
 *
 * See the printed documentation generated by \c this->print_step().
 */
class CheckConvergenceStd_Strategy :
    public CheckConvergence_Strategy
  {
  public:
    CheckConvergenceStd_Strategy(
      EOptErrorCheck opt_error_check = OPT_ERROR_REDUCED_GRADIENT_LAGR,
      EScaleKKTErrorBy scale_opt_error_by = SCALE_BY_ONE,
      EScaleKKTErrorBy scale_feas_error_by = SCALE_BY_ONE,
      EScaleKKTErrorBy scale_comp_error_by = SCALE_BY_ONE,
      bool scale_opt_error_by_Gf = true
      );
    
    /** @name Overridden from CheckConvergence_Strategy */
    //@{
    /** \brief . */
    virtual bool Converged( Algorithm& _algo);

    /** \brief . */
    virtual void print_step( const Algorithm& _algo, std::ostream& out, const std::string& L ) const;

    //@}

  protected:

    value_type CalculateScalingFactor( NLPAlgoState& state, EScaleKKTErrorBy scale_by ) const;

  }; // end class CheckConvergenceStd_Strategy

} // end namespace MoochoPack

#endif // CHECK_CONVERGENCE_STD_STRATEGY_H

