// $Id: Sacado_ScalarParameterVector.hpp,v 1.1 2007/05/22 21:51:53 etphipp Exp $ 
// $Source: /space/CVS/Trilinos/packages/sacado/src/parameter/Sacado_ScalarParameterVector.hpp,v $ 
// @HEADER
// ***********************************************************************
// 
//                           Sacado Package
//                 Copyright (2006) Sandia Corporation
// 
// Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
// the U.S. Government retains certain rights in this software.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//  
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
// Questions? Contact David M. Gay (dmgay@sandia.gov) or Eric T. Phipps
// (etphipp@sandia.gov).
// 
// ***********************************************************************
// @HEADER

#ifndef SACADO_SCALARPARAMETERVECTOR_HPP
#define SACADO_SCALARPARAMETERVECTOR_HPP

#include "Sacado_ParameterVectorBase.hpp"
#include "Sacado_ScalarParameterFamily.hpp"

namespace Sacado {

  /*! 
   * \brief Specialization of Sacado::ParameterVectorBase for scalar parameters
   */
  class ScalarParameterVector : 
    public ParameterVectorBase<ScalarParameterFamily, double> {

  public:
  
    //! Default constructor
    ScalarParameterVector() {}

    //! Copy constructor
    ScalarParameterVector(const ScalarParameterVector& source) :
      ParameterVectorBase<ScalarParameterFamily, double>(source) {}

    //! Destructor
    virtual ~ScalarParameterVector() {}

    //! Assignment operator
    ScalarParameterVector& operator = (const ScalarParameterVector& source) {
      ParameterVectorBase<ScalarParameterFamily, double>::operator=(source);
      return *this;
    }

  };
  
}

#endif
