/*
 * class InfoAST (derived from CommonAST):
 * An AST node class providing additional line and column information
 *
 * Copyright (C) 2001 Michael Schmitt <schmitt@itm.mu-luebeck.de>
 *
 *    Institute for Telematics,
 *    Medical University of Luebeck,
 *    Ratzeburger Allee 160,
 *    23538 Luebeck,
 *    Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "InfoAST.hpp"

ANTLR_BEGIN_NAMESPACE(antlr)

ANTLR_USE_NAMESPACE(std)map< RefString, RefString > InfoAST::_filenames;


InfoAST::InfoAST() : _line( 0 ), _column( 0 )
{
}


InfoAST::InfoAST( RefToken t ) : CommonAST( t ), _line( 0 ), _column( 0 )
{
}


void InfoAST::initialize( int t, const ANTLR_USE_NAMESPACE(std)string& txt )
{
  CommonAST::initialize( t, txt );

  _line = _column = 0;
}


void InfoAST::initialize( RefAST t )
{
  const InfoAST   *infoAST;

  CommonAST::initialize( t );
  
  if ( ( infoAST = dynamic_cast< const InfoAST * >( t.get() ) ) != 0 )
  {
    _line = infoAST -> _line;
    _column = infoAST -> _column;
  }
  else
    _line = _column = 0;
}


void InfoAST::initialize( RefToken t )
{
  CommonAST::initialize( t );
  
  _line   = t -> getLine();
  _column = t -> getColumn();

  // There is no clean solution for setting the filename right now
  //
  // RefString file_name( new string( ( ( ANTLR_USE_NAMESPACE(antlr)CharScanner*)
  //           selector.getCurrentStream())-&gt;getFilename()));
  // if (_filenames.find(file_name) == _filenames.end()) {// not found
  //    _filenames[file_name] = file_name;
  //    _filename = file_name;
  // } else {
  //    _filename = _filenames[file_name];
  // }
}


int InfoAST::getLine() const
{
  const InfoAST   *ast;
 
  for ( ast = this; ast != 0 && ast != static_cast< RefInfoAST >( antlr::nullAST ); 
        ast = dynamic_cast< const InfoAST * >( ast -> getFirstChild().get() ) ) 
  { 
    if ( ast -> _line != 0 )
      return ast -> _line;
  }

  return 0;
}


void InfoAST::setLine( int line )
{ 
  _line = line; 
}


int InfoAST::getColumn() const
{
  const InfoAST   *ast;
 
  for ( ast = this; ast != 0 && ast != static_cast< RefInfoAST >( antlr::nullAST );
        ast = dynamic_cast< const InfoAST * >( ast -> getFirstChild().get() ) )
  {
    if ( ast -> _column != 0 )
      return ast -> _column;
  }
 
  return 0;
} 


void InfoAST::setColumn( int column )
{ 
  _column = column;
}


const ANTLR_USE_NAMESPACE(std)string &InfoAST::getFilename() const
{ 
  return *_filename; 
}

// required for ANTLRs factory design pattern
RefAST InfoAST::factory()
{
  return RefAST( new InfoAST );
}

ANTLR_END_NAMESPACE
