#!/usr/bin/ruby

=begin
  po2ul - generate a sorted list of unicode codepoint used in po files.

  Copyright (C) 2005  Hidetaka Iwai  <tyuyu@debian.or.jp>
  
  Depends: ruby (>= 1.8), libgettext-ruby1.8
=end

require 'gettext/rmsgfmt'
require 'iconv'
include GetText

def parse(data)
  ret = MOFile.new
  parser = PoParser.new
  msgstr = ""

  parser.parse(data, ret)
  /charset=(.*)$/ =~ ret[""]
  encoding = $1 
  ret.delete("") # Remove meta information

  ret = {"msgstr" => ret.values.join,
    "encoding" => encoding,}
end

list = []
if ARGV.size == 0
  ret = parse(STDIN.read)
  list += Iconv.conv("UCS-4BE", ret["encoding"], ret["msgstr"]).unpack("N*")
else
  while filename = ARGV.shift
    next unless (st = File.stat(filename)) && st.file? && st.readable?
    ret = parse(File.open(filename).read)
    list += Iconv.conv("UCS-4BE", ret["encoding"], ret["msgstr"]).unpack("N*")
  end
end

puts list.uniq.sort
