/* vim: set ts=8 sts=4 sw=4 tw=80 noet: */
/*======================================================================
Copyright (C) 2004,2005,2009,2013 Walter Doekes <walter+tthsum@wjd.nu>
This file is part of tthsum.

tthsum is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

tthsum is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with tthsum.  If not, see <http://www.gnu.org/licenses/>.
======================================================================*/
#include "texts.h"

#include "test.h"
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>


static int test_texts_initial() {
    const char* err;
    set_error("some context", ERROR_FIRST); /* reset errors */
    err = get_error();
    TEST_PASS1(strcmp(err, "some context: No error yet") == 0,
	    "Unexpected \"No-error-yet\" text, got: \"%s\"", err);
    return 0;
}

static int test_texts_enum() {
    const char* err;
    int tid;
    for (tid = ERROR_FIRST; tid != ERROR_LAST; ++tid) {
	set_error("another context", tid);
	err = get_error();
	TEST_PASS1(strncmp(err, "another context", 15) == 0,
		"Error text context mismatch, got: \"%s\"", err);
	TEST_PASS2(strcmp(err + 17, get_text((enum text_id)tid)) == 0,
		"Error text mismatch for text id %i, got: \"%s\"", tid, err);
    }
    return 0;
}

static int test_texts_oserror() {
    const char* err;
    open("", O_RDONLY);
    set_error("yet another context", ERROR_FROM_OS);
    err = get_error();
#ifdef _WIN32
    TEST_PASS1(strcmp(err, "yet another context: "
	    "The system cannot find the path specified. (0x3)") == 0,
	    "Unexpected OS error text, got: \"%s\"", err);
#else /* !_WIN32 */
    TEST_PASS1(strcmp(err, "yet another context: "
	    "No such file or directory (2)") == 0,
	    "Unexpected OS error text, got: \"%s\"", err);
#endif /* !_WIN32 */
    return 0;
}


TESTS(texts_test)
    TEST(test_texts_initial);
    TEST(test_texts_enum);
    TEST_WARN(test_texts_oserror);
ENDTESTS
