/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>
    and authors of web browser Links 0.96

    This program is free software; you can redistribute it and/or                                                        
    modify it under the terms of the GNU General Public License                                                          
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

extern long int starting_sbrk;

int fileno(FILE *stream);


void menu_about(union cba_t cba)
{
    msg_box(NULL, VTEXT(T_ABOUT), AL_CENTER, VTEXT(T_TUCNAK__TACLOG_LIKE), NULL, 1, VTEXT(T_OK), NULL, B_ENTER | B_ESC);
}

void menu_copying(union cba_t cba)
{
    msg_box(NULL, VTEXT(T_COPYING), AL_CENTER, VTEXT(T_COPYING_VER), NULL, 1, VTEXT(T_OK), NULL, B_ENTER | B_ESC);
}

void menu_contest_new(union cba_t cba)
{
    if (ctest){
        msg_box(NULL, VTEXT(T_WARNING), AL_CENTER,VTEXT(T_CTEST_ACTIVE), NULL,1, VTEXT(T_CANCEL), NULL, B_ENTER |B_ESC); 
        return;
    }
    contest_options1_from_menu(cba);
}

void menu_contest_new_wizz(union cba_t cba)
{
    if (ctest){
        msg_box(NULL, VTEXT(T_WARNING),AL_CENTER, VTEXT(T_CTEST_ACTIVE), NULL,1, VTEXT(T_CANCEL), NULL, B_ENTER |B_ESC); 
        return;
    }
    menu_wizz(cba);
}


void menu_contest1_options_from_ctest(union cba_t cba)
{
    contest_options1_from_ctest(cba);
}




int select_dir_func(const struct dirent *de){
    struct stat st;
    gchar *f;
    
    if (strcmp((char *)de->d_name, "00000000")==0) return 0;
    if (regcmp((char *)de->d_name, "^[0-9]{8}(\\.[0-9]+)?$")) return 0;

    f = g_strconcat(getenv("HOME"), "/tucnak/", de->d_name, NULL); 
    if (stat(f, &st)) {
        g_free(f);
        return 0;
    }
    g_free(f);
    if (!S_ISDIR(st.st_mode)) return 0;

    return 1;
}

/*int compare_dir_func(const struct dirent **pde1, const struct dirent **pde2){*/
int compare_dir_func(const void *d1, const void *d2){
    char *c1, *c2;
    int r, n1, n2;
    const struct dirent **pde1, **pde2;
    
    pde1=(const struct dirent **)d1;
    pde2=(const struct dirent **)d2;

    r = strncmp( (*pde1)->d_name, (*pde2)->d_name, 8);
    if (r!=0) return -r;
        
    c1 = index( (*pde1)->d_name , '.');
    c2 = index( (*pde2)->d_name , '.');

    n1 = c1 ? atoi(c1+1) : 0;
    n2 = c2 ? atoi(c2+1) : 0;
    
    return n2 - n1;
}

struct menu_item no_contests[] = {
    {CTEXT(T_NO_CTESTS), "", M_BAR, NULL, {NULL}, 0, 0},
    {NULL, NULL, 0, NULL, {NULL}, 0, 0}
};

void menu_load_contest(union cba_t dir, union cba_t unused){
    /*dbg("menu_load_contest('%s')\n", dir);*/
  
    load_contest_edi(dir.charp, 0);
    redraw_later();
} 

static struct dirent **namelist=NULL;
static int namelistlen = 0;
    
void free_namelist(void){
    int i;

    if (!namelistlen) return;
    
    for (i=0; i<namelistlen; i++)     
        free(namelist[i]);
    free(namelist);
    namelist = NULL;
    namelistlen = 0;
}

void menu_contest_open(union cba_t cba)
{
    int i, n, max=0;
    gchar *dir;
    struct menu_item *mi = NULL;
    char s[1025], *d;
    union cba_t cba0;
    
    /*dbg("open contest \n");*/

    free_namelist();
        
    dir = g_strdup_printf("%s/tucnak", getenv("HOME"));
#if 0
#ifdef HAVE_SCANDIR_PROTOTYPE_1    
     /* glibc 2.2.4 */   
    n = scandir(dir, &namelist, select_dir_func,(int (*)(const void*, const void*))compare_dir_func);
#elif HAVE_SCANDIR_PROTOTYPE_2
    /*  cygwin */
    n = scandir(dir, &namelist, select_dir_func,(int (*)(const struct dirent **, const struct dirent **)) compare_dir_func);
#else    
    /*  libc5  */
    n = scandir(dir, &namelist, select_dir_func,(int (*)(__const struct dirent * __const *, __const struct dirent * __const *)) compare_dir_func);
#endif    
#endif    
    
    n = tucnak_scandir(dir, &namelist, select_dir_func, compare_dir_func);
 
    if (n<=0){
        do_menu(no_contests, cba0);
        return;
    }
    
    if (!(mi = new_menu(3))) return;
    for (i=0; i<n; i++){
        FILE *f;
        gchar *c;
        int locked=0;
        union cba_t cba2;
        gchar **items;
/*      
 *      dbg("'%s'\n", namelist[i]->d_name);*/
        
        c=g_strdup_printf("%s/%s/desc", dir, namelist[i]->d_name);
                
        memset(s, 0, sizeof(s));
        d = NULL;
        f = fopen(c, "rt");
        if (f){
            locked=0;
            if (lockf(fileno(f), F_TEST, 0)) locked=1;
            if (fgets(s,1024,f)!=NULL){
                if (strlen(s)>0 && s[strlen(s)-1]=='\n') s[strlen(s)-1]='\0';
                if (strlen(s)>0 && s[strlen(s)-1]=='\r') s[strlen(s)-1]='\0';
                d = index(s,' ');
                if (d) d++;
            }
            fclose(f);
        }
        g_free(c);

        
        if (!d) d=s;
        if (strlen(d)>50) d[50]='\0';
        
        items=g_strsplit(d, " ", 2);
        if (items && items[0] && items[1]){
            c = g_strdup_printf("%-12s%-6s  %s", namelist[i]->d_name, items[0], items[1]);
        }else{
            c = g_strdup_printf("%-12s%s", namelist[i]->d_name, d);
        }
        if (items) g_strfreev(items);
        
        
        
        if (strlen(c)>max) max=strlen(c);
        cba2.charp=namelist[i]->d_name;
        add_to_menu(&mi, 
                stracpy(c), 
                locked? "!":"", "", 
                menu_load_contest, cba2, 0);    
        g_free(c);
    }
    g_free(dir);
    
    set_window_ptr(gses->win, (term->x-6-max)/2,(term->y-2-i)/2);

    cba0.int_=0;
    do_menu(mi, cba0);
}


void really_close_ctest(void)
{
    rel_write_all("CL\n");
    save_all_bands_txt(0);    
    free_ctest();
}

void menu_save_all(union cba_t cba){
    save_all_bands_txt(0);    
}

void menu_export_edi(union cba_t cba){
    export_all_bands_edi();    
}

void menu_export_adif(union cba_t cba){
    export_all_bands_adif();    
}

void menu_export_report(union cba_t cba){
    export_all_bands_report();    
}

void menu_export_html(union cba_t cba){
    export_all_bands_html();    
}

void menu_export_stats(union cba_t cba) {
	export_stats_fifo();
}

void menu_export_titlpage(union cba_t cba) {
	export_all_bands_titlpage();
}



void menu_import_edi(union cba_t cba){
    char *pwd;
    
    pwd=getcwd(NULL, 0);
    input_field(NULL, VTEXT(T_IMPORT_EDI), VTEXT(T_FILENAME), 
               VTEXT(T_OK), VTEXT(T_CANCEL), gses, 
               NULL, 50, pwd, 0, 0, NULL,
               import_edi, NULL);
    if (pwd) free(pwd);
}

void menu_import_adif(union cba_t cba){
    char *pwd;
    
    pwd=getcwd(NULL, 0);
    input_field(NULL, VTEXT(T_IMPORT_ADIF), VTEXT(T_FILENAME), 
               VTEXT(T_OK), VTEXT(T_CANCEL), gses, 
               NULL, 50, pwd, 0, 0, NULL,
               import_adif, NULL);
    if (pwd) free(pwd);
}

void menu_import_swap(union cba_t cba){
    char *pwd;
    
    pwd=getcwd(NULL, 0);
    input_field(NULL, VTEXT(T_IMPORT_SWAP), VTEXT(T_FILENAME), 
               VTEXT(T_OK), VTEXT(T_CANCEL), gses, 
               NULL, 50, pwd, 0, 0, NULL,  
               import_swap, NULL);
    if (pwd) free(pwd);
}





void menu_contest_close(union cba_t cba)
{
    if (!ctest){
        msg_box(NULL, VTEXT(T_WARNING),AL_CENTER,VTEXT(T_NO_CCLOSE),NULL,1, VTEXT(T_CANCEL), NULL, B_ENTER |B_ESC); 
        return;
    }
    msg_box(NULL, VTEXT(T_REALLY), AL_CENTER, 
            VTEXT(T_CLOSE_CTEST),gses, 2, 
            VTEXT(T_YES), (void (*)(void *))really_close_ctest, B_ENTER, 
            VTEXT(T_NO), NULL, B_ESC);
}






   /****************************************************************************/
    
void really_exit_prog(void)
{
    register_bottom_half(destroy_terminal, CBA0);
}

void dont_exit_prog(void)
{
    gses->exit_query = 0;
}

void query_exit(void)
{
    gses->exit_query = 1;
   msg_box(NULL, VTEXT(T_EXIT_TUCNAK), AL_CENTER, 
           VTEXT(T_DO_YOU_REALLY_WANT_TO_EXIT_TUCNAK), gses, 2, VTEXT(T_YES), (void (*)(void *))really_exit_prog, B_ENTER, VTEXT(T_NO), dont_exit_prog, B_ESC);
}

void exit_prog(union cba_t cba)
{
    if (!gses) {
        register_bottom_half(destroy_terminal, CBA0);
        return;
    }

    if (1){
        query_exit();
        return;
    }
    really_exit_prog();
}

struct refresh {
/*    struct terminal *term;*/
    struct window *win;
/*    struct session *ses;*/
    void (*fn)(union cba_t cba);
    union cba_t data;
    int timer;
};

void refresh(struct refresh *r)
{
    struct refresh rr;
    r->timer = -1;
    memcpy(&rr, r, sizeof(struct refresh));
    delete_window(r->win);
    rr.fn(rr.data);
}

void end_refresh(struct refresh *r)
{
    if (r->timer != -1) kill_timer(r->timer);
    mem_free(r);
}

void refresh_abort(struct dialog_data *dlg)
{
    end_refresh(dlg->dlg->udata2);
}



void memory_cld(struct terminal *term, void *d)
{
#ifdef LEAK_DEBUG    
    last_mem_amount = mem_amount;
#endif    
}

/* FIXME! overflow */
#define MSG_BUF 4000
#define MSG_W   100

void memory_info(union cba_t cba)
{
    char message[MSG_BUF];
    char *p;
    struct refresh *r;
    FILE *f;
    char s[1026], *c1, *c2, *c3;
    int cnt=1;
    
    if (!(r = mem_alloc(sizeof(struct refresh)))) return;
/*    r->term = term;*/
    r->win = NULL;
/*//    r->ses = ses;*/
    r->fn = memory_info;
    r->data = cba;
    r->timer = -1;
    p = message;
#ifdef LEAK_DEBUG    
    p += sprintf(p, VTEXT(T_GUI_LD), mem_amount);
    if (last_mem_amount != -1) p += sprintf(p, ", %s %ld, %s %ld", VTEXT(T_LAST), last_mem_amount, VTEXT(T_DIFFERENCE), mem_amount - last_mem_amount);
#endif    
    p += sprintf(p, VTEXT(T_SBRK), (long int)sbrk(0)-starting_sbrk);
    p += sprintf(p, ".\n");

    p += sprintf(p, VTEXT(T_CWI), get_cw_size(cw), get_wc_size(cw), cw->latest); 
    p += sprintf(p, VTEXT(T_DWI), get_pd_size(dw), get_dw_size(dw), get_wd_size(dw)); 
    p += sprintf(p, VTEXT(T_NAMES), get_namedb_size(namedb)); 

    f = fopen("/proc/self/status", "rt");
    if (f){
        p+=sprintf(p,VTEXT(T_MEMS), 0xf00l);
        while (fgets(s, 1024, f)!=NULL){
/*            dbg("%s", s);*/
            if (regmatch(s, "Vm(.*):. *([0-9 a-zA-Z]+)", &c1, &c2, &c3, NULL)==0){
/*                dbg("match '%s' '%s' \n", c2, c3);*/
                p+=sprintf(p, " %s=%s ", c2, c3);
                cnt++;
                if (cnt==3){
                    cnt=0;
                    p+=sprintf(p, "\n");
                }
                mem_free(c1);mem_free(c2);mem_free(c3);
            }
            
        }
        
        fclose(f);
    }

    if (!(p = stracpy(message))) {
        mem_free(r);
        return;
    }
    msg_box(getml(p, NULL), VTEXT(T_MEMORY_INFO), AL_CENTER, p, r, 1, VTEXT(T_OK), NULL, B_ENTER | B_ESC);
    r->win = term->windows.next;
    ((struct dialog_data *)r->win->data)->dlg->abort = refresh_abort;
    r->timer = install_timer(RESOURCE_INFO_REFRESH, (void (*)(union cba_t))refresh, (union cba_t)r);
}


void net_info(union cba_t cba)
{
    char message[MSG_BUF];
    char *p;
    struct refresh *r;
    int i;
    
    if (!(r = mem_alloc(sizeof(struct refresh)))) return;
/**   r->term = term;*/
    r->win = NULL;
/*    r->ses = ses;*/
    r->fn = net_info;
    r->data = cba;
    r->timer = -1;
    p = message;
    p += sprintf(p,VTEXT(T_NMY), inet_ntoa(net->my.sin_addr), ntohs(net->my.sin_port)); 
    p += sprintf(p,VTEXT(T_NGLOBAL), inet_ntoa(net->global.sin_addr), ntohs(net->global.sin_port)); 
    if (net->master){
        p += sprintf(p,VTEXT(T_NMASTER), ns_desc[net->master->state], 
                                                net->master->operator?net->master->operator:"",
                                                inet_ntoa(net->master->sin.sin_addr), 
                                                ntohs(net->master->sin.sin_port),
                                                net->master->is_same_ctest?"OK":"--",
                                                get_timer_str(net->master)); 
    }
    if (net->peers->len>0){
        p += sprintf(p, VTEXT(T_NSLAVES), 0xf001); 
    }
    for (i=0;i<net->peers->len; i++){
        struct conn *conn;
        
        conn = g_ptr_array_index(net->peers, i);
        /*p += sprintf(p, "%s %s:%d\n", ns_desc[conn->state], inet_ntoa(conn->sin.sin_addr), ntohs(conn->sin.sin_port)); */
        p += sprintf(p, "%s %-6s %s %s %s\n", 
                ns_desc[conn->state], 
                conn->operator?conn->operator:"",
                conn->remote_id, 
                conn->is_same_ctest?"OK":"--",
                get_timer_str(conn)); 
    }

    if (!(p = stracpy(message))) {
        mem_free(r);
        return;
    }
    msg_box(getml(p, NULL), VTEXT(T_NINFO), AL_LEFT, p, r, 1, VTEXT(T_OK), NULL, B_ENTER | B_ESC);
    r->win = term->windows.next;
    ((struct dialog_data *)r->win->data)->dlg->abort = refresh_abort;
    r->timer = install_timer(RESOURCE_INFO_REFRESH, (void (*)(union cba_t))refresh, (union cba_t)r);
}



struct menu_item no_bands_qrv_menu[] = {
    {CTEXT(T_NO_BANDS_QRV), "", M_BAR, NULL, {NULL}, 0, 0},
    {NULL, NULL, 0, NULL, {NULL}, 0, 0}
};

struct menu_item no_bands_configured_menu[] = {
    {CTEXT(T_NO_BANDS_CONF), "", M_BAR, NULL, {NULL}, 0, 0},
    {NULL, NULL, 0, NULL, {NULL}, 0, 0},
};

void menu_activate_band(union cba_t cba){
    struct band *b;
    char *pband;
    
    pband=cba.charp;
    /*dbg("menu_activate_band(term=%p, pband='%s', ses=%p)\n",term,pband,ses);*/
    
    b=find_band_by_pband(pband);
    activate_band(b);
    
}


    
void menu_setup_band(union cba_t cba){
    /* cba.charp=pband */
    band_settings(cba, 0);
}

void bands_menu(union cba_t cba)
{
    struct menu_item *mi = NULL;
    int i;
    
    if (cba.void_==menu_activate_band){
        if (!ctest || !ctest->bands->len) {
/*            union cba_t cba2;
            cba2.menu_item=no_bands_qrv_menu;*/
            do_menu(no_bands_qrv_menu, CBA0);
            return;
        }

        for (i=0;i<ctest->bands->len;i++){
            struct band *b;
            union cba_t cba2;
            static char *bandstrs[]={"A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"};

            b = g_ptr_array_index(ctest->bands,i);

            if (!mi) if (!(mi = new_menu(3))) return;
            cba2.charp=b->pband;
            add_to_menu(&mi, 
                    stracpy(b->pband), 
                    bandstrs[upcase(b->bandchar)-'A'],
                    bandstrs[upcase(b->bandchar)-'A'],
                    MENU_FUNC cba.void_, cba2, 0);
        }


        
    }else{
        union cba_t cba0;

        cba0.void_=NULL;

        if (!cfg || !cfg->bands->len) {
            do_menu(no_bands_configured_menu, cba0);
            return;
        }
        
        for (i=0;i<cfg->bands->len;i++){
            struct config_band *b;
            union cba_t cba2;
            static char *bandstrs[]={"A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"};

            b = g_ptr_array_index(cfg->bands,i);
            if (!b->qrv) continue;

            if (!mi) if (!(mi = new_menu(3))) return;
            cba2.charp=b->pband;
            dbg("add_to_menu(%c,'%s','%s')\n", b->bandchar, b->pband, bandstrs[upcase(b->bandchar)-'A']);
            add_to_menu(&mi, 
                    stracpy(b->pband), 
                    bandstrs[upcase(b->bandchar)-'A'],
                    bandstrs[upcase(b->bandchar)-'A'],
                    MENU_FUNC cba.void_, cba2, 0);
        }  
        
        if (mi) add_to_menu(&mi, stracpy(""), "", M_BAR, NULL, cba0, 0);
        
        for (i=0;i<cfg->bands->len;i++){
            struct config_band *b;
            union cba_t cba2;
            static char *bandstrs[]={"A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"};

            b = g_ptr_array_index(cfg->bands,i);
            if (b->qrv) continue;

            if (!mi) if (!(mi = new_menu(3))) return;
            cba2.charp=b->pband;
            add_to_menu(&mi, 
                    stracpy(b->pband), 
                    bandstrs[upcase(b->bandchar)-'A'],
                    bandstrs[upcase(b->bandchar)-'A'],
                    MENU_FUNC cba.void_, cba2, 0);
        }  
    }
    do_menu(mi, CBA0);
}

struct menu_item not_available[] = {
    {CTEXT(T_NOT_AVAILABLE), "", M_BAR, NULL, {NULL}, 0, 0},
    {NULL, NULL, 0, NULL, {NULL}, 0, 0}
};



void menu_activate_subwin(union cba_t cba){
    /*dbg("menu_activate_subwin %d\n", (int)ddd);*/

    if (sw_set_ontop(cba.int_)){
        if (gses->focused){
            sw_set_focus();
            il_unset_focus(INPUTLN(aband));
        }else{
            sw_unset_focus();
            il_set_focus(INPUTLN(aband));
        }
        redraw_later();
    }
}


void subwins_menu(union cba_t cba)
{
    struct menu_item *mi = NULL;
    int i;
    char s[16];
    
    /*if (!ctest) {
        do_menu(not_available, CBA0);
        return;
    }     */

    if (!(mi = new_menu(3))) return;
    add_to_menu(&mi, stracpy(VTEXT(T_ADD_SUBWIN)), "", VTEXT(T_HK_ADD_SUBWIN), MENU_FUNC menu_add_subwin, CBA0, 0);
    add_to_menu(&mi, stracpy(VTEXT(T_CLOSE_SUBWIN)), "", VTEXT(T_HK_CLOSE_SUBWIN), MENU_FUNC menu_close_subwin, CBA0, 0);
    add_to_menu(&mi, stracpy(""), "", M_BAR, NULL, CBA0, 0);

    for (i=0;i<gses->subwins->len;i++){
        struct subwin *sw;
        union cba_t cba2;

        sw = g_ptr_array_index(gses->subwins,i);

        sprintf(s,"%d", i);
        cba2.int_=i;
        add_to_menu(&mi, 
                stracpy(sw->title), 
                "",
                "",
                MENU_FUNC menu_activate_subwin, cba2, 0);
    }
    do_menu(mi, CBA0);
}


/****************** NETWORK ********************************************/

void display_codepage(union cba_t cba)
{
    int cp = cba.int_;
    struct term_spec *t = new_term_spec(term->term);
    if (t) t->charset = cp;
    redraw_terminal_cls();
}

void charset_list(union cba_t cba)
{
    int i, sel;
    char *n;
    struct menu_item *mi;
    union cba_t cba2;
    
    if (!(mi = new_menu(1))) return;
    for (i = 0; (n = get_cp_name(i)); i++) {
        if (is_cp_special(i)) continue;

        cba2.int_=i;
        add_to_menu(&mi, get_cp_name(i), "", "", MENU_FUNC display_codepage, cba2, 0);
    }
    sel = term->spec->charset;
    if (sel < 0) sel = 0;
    do_menu_selected(mi, CBA0, sel);
}

/*void set_val(union cba_t *ip, union cba_t *d)
{
    *d = (vint)ip;
}

void charset_sel_list(union cba_t cba)
{
    int i, sel;
    char *n;
    struct menu_item *mi;
    if (!(mi = new_menu(1))) return;
    for (i = 0; (n = get_cp_name(i)); i++) {
        union cba_t cba2;

        cba2.int_=i;
        add_to_menu(&mi, get_cp_name(i), "", "", MENU_FUNC set_val, cba2, 0);
    }
    sel = *ptr;
    if (sel < 0) sel = 0;
    do_menu_selected(term, mi, ptr, sel);
}  */

void terminal_options_ok(void *p)
{
    redraw_terminal_cls();
}

char *td_labels[] = { CTEXT(T_NO_FRAMES), CTEXT(T_VT_100_FRAMES), CTEXT(T_LINUX_OR_OS2_FRAMES), CTEXT(T_KOI8R_FRAMES), CTEXT(T_USE_11M), CTEXT(T_RESTRICT_FRAMES_IN_CP850_852), CTEXT(T_BLOCK_CURSOR), CTEXT(T_COLOR), CTEXT(T_UTF_8_IO), NULL };

void terminal_options(union cba_t cba)
{
    struct dialog *d;
    struct term_spec *ts = new_term_spec(term->term);
    if (!ts) return;
    if (!(d = mem_alloc(sizeof(struct dialog) + 12 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 12 * sizeof(struct dialog_item));
    d->title = VTEXT(T_TERMINAL_OPTIONS);
    d->fn = checkbox_list_fn;
    d->udata = td_labels;
    d->refresh = (void (*)(void *))terminal_options_ok;
    d->items[0].type = D_CHECKBOX;
    d->items[0].gid = 1;
    d->items[0].gnum = TERM_DUMB;
    d->items[0].dlen = sizeof(int);
    d->items[0].data = (void *)&ts->mode;
    d->items[1].type = D_CHECKBOX;
    d->items[1].gid = 1;
    d->items[1].gnum = TERM_VT100;
    d->items[1].dlen = sizeof(int);
    d->items[1].data = (void *)&ts->mode;
    d->items[2].type = D_CHECKBOX;
    d->items[2].gid = 1;
    d->items[2].gnum = TERM_LINUX;
    d->items[2].dlen = sizeof(int);
    d->items[2].data = (void *)&ts->mode;
    d->items[3].type = D_CHECKBOX;
    d->items[3].gid = 1;
    d->items[3].gnum = TERM_KOI8;
    d->items[3].dlen = sizeof(int);
    d->items[3].data = (void *)&ts->mode;
    d->items[4].type = D_CHECKBOX;
    d->items[4].gid = 0;
    d->items[4].dlen = sizeof(int);
    d->items[4].data = (void *)&ts->m11_hack;
    d->items[5].type = D_CHECKBOX;
    d->items[5].gid = 0;
    d->items[5].dlen = sizeof(int);
    d->items[5].data = (void *)&ts->restrict_852;
    d->items[6].type = D_CHECKBOX;
    d->items[6].gid = 0;
    d->items[6].dlen = sizeof(int);
    d->items[6].data = (void *)&ts->block_cursor;
    d->items[7].type = D_CHECKBOX;
    d->items[7].gid = 0;
    d->items[7].dlen = sizeof(int);
    d->items[7].data = (void *)&ts->col;
    d->items[8].type = D_CHECKBOX;
    d->items[8].gid = 0;
    d->items[8].dlen = sizeof(int);
    d->items[8].data = (void *)&ts->utf_8_io;
    d->items[9].type = D_BUTTON;
    d->items[9].gid = B_ENTER;
    d->items[9].fn = ok_dialog;
    d->items[9].text = VTEXT(T_OK);
    d->items[10].type = D_BUTTON;
    d->items[10].gid = B_ESC;
    d->items[10].fn = cancel_dialog;
    d->items[10].text = VTEXT(T_CANCEL);
    d->items[11].type = D_END;
    do_dialog(d, getml(d, NULL));
}


void menu_shell(union cba_t cba)
{
    char *sh;
    if (!(sh = GETSHELL)) sh = DEFAULT_SHELL;
    exec_on_terminal(sh, "", 1);
}

void menu_set_language(union cba_t cba)
{
    set_language(cba.int_);
    redraw_terminal_cls();
}

void menu_language_list(union cba_t cba)
{
    int i, sel;
    char *n;
    struct menu_item *mi;
    if (!(mi = new_menu(1))) return;
    for (i = 0; i < n_languages(); i++) {
        union cba_t cba2;

        cba2.int_=i;
        n = language_name(i);
        add_to_menu(&mi, n, "", "", MENU_FUNC menu_set_language, cba2, 0);
    }
    sel = current_language;
    do_menu_selected(mi, CBA0, sel);
}


struct menu_item file_menu22[] = {
/*  "", "", M_BAR, NULL, NULL, 0, 0,*/
    {CTEXT(T_PLAY_LAST), "Ctrl+P", CTEXT(T_HK_PLAY_LAST), MENU_FUNC menu_play_last, {NULL}, 0, 0},
    {CTEXT(T_BREAK_RECORD), "", CTEXT(T_HK_BREAK_RECORD), MENU_FUNC menu_break_record, {NULL}, 0, 0},
    {"", "", M_BAR, NULL, {NULL}, 0, 0},
    {CTEXT(T_MEMORY_INFO), "", CTEXT(T_HK_MEMORY_INFO), MENU_FUNC memory_info, {NULL}, 0, 0},
    {CTEXT(T_NINFO), "", CTEXT(T_HK_NINFO), MENU_FUNC net_info, {NULL}, 0, 0},
    {"", "", M_BAR, NULL, {NULL}, 0, 0}
};

struct menu_item file_menu3[] = {
    {"", "", M_BAR, NULL, {NULL}, 0, 0},
    {CTEXT(T_EXIT), "", CTEXT(T_HK_EXIT), MENU_FUNC exit_prog, {NULL}, 0, 0},
    {NULL, NULL, 0, NULL, {NULL}, 0, 0}
};

#ifndef HAVE_SDL
#define sdl 0
#endif
void do_file_menu(union cba_t cba)
{
    int x,file_menu1_size;
    struct menu_item *file_menu, *e, *f;
    
    file_menu1_size=0;    

    if (!(file_menu = mem_alloc(file_menu1_size +
                                sizeof(file_menu22) + 
                                sizeof(file_menu3) + 
                                3 * sizeof(struct menu_item)))) return;
    e = file_menu;
    memcpy(e, file_menu22, sizeof(file_menu22));
    e += sizeof(file_menu22) / sizeof(struct menu_item);
    x = 1;
    if (can_open_os_shell(term->environment) && !sdl) {
        e->text = VTEXT(T_OS_SHELL);
        e->rtext = "";
        e->hotkey = VTEXT(T_HK_OS_SHELL);
        e->func = MENU_FUNC menu_shell;
        e->data = CBA0;
        e->in_m = 0;
        e->free_i = 0;
        e++;
        x = 0;
    }
    memcpy(e, file_menu3 + x, sizeof(file_menu3) - x * sizeof(struct menu_item));
    e += sizeof(file_menu3) / sizeof(struct menu_item);
    for (f = file_menu; f < e; f++) f->free_i = 1;
    do_menu(file_menu, CBA0);
}
#ifndef HAVE_SDL
#undef sdl
#endif


struct menu_item help_menu[] = {
    {CTEXT(T_ABOUT), "", CTEXT(T_HK_ABOUT), MENU_FUNC menu_about, {NULL}, 0, 0},
    {CTEXT(T_COPYING), "", CTEXT(T_HK_COPYING), MENU_FUNC menu_copying, {NULL}, 0, 0},
    {NULL, NULL, 0, NULL, {NULL}, 0, 0}
};



/************************* CONTEST MENU *********************************/

struct menu_item ctest_menu1[] = {
    {CTEXT(T_NEW),        "", CTEXT(T_HK_NEW), MENU_FUNC menu_contest_new, {NULL}, 0, 0},
    {CTEXT(T_NEW_WIZZ),   ">", CTEXT(T_HK_NEW_WIZZ), MENU_FUNC menu_contest_new_wizz, {NULL}, 1, 0},
    {CTEXT(T_OPEN),       "F3 >", CTEXT(T_HK_OPEN), MENU_FUNC menu_contest_open, {NULL}, 1, 0},
    {NULL, NULL, 0, NULL, {NULL}, 0, 0}
};
    
struct menu_item ctest_menu2[] = {
    {CTEXT(T_SAVE),           "F2", CTEXT(T_HK_SAVE), MENU_FUNC menu_save_all, {NULL}, 0, 0},
    {CTEXT(T_FILLOP),         "", CTEXT(T_HK_FILLOP), MENU_FUNC menu_fillop, {NULL}, 0, 0},
    {CTEXT(T_QSO_CHECK),      "", CTEXT(T_HK_QSO_CHECK), MENU_FUNC menu_qso_check, {NULL}, 0, 0},
    {"", "", M_BAR, NULL, {NULL}, 0, 0},
    {CTEXT(T_EXPORT_EDI),     "",  CTEXT(T_HK_EXPORT_EDI), MENU_FUNC menu_export_edi, {NULL}, 0, 0},
    {CTEXT(T_EXPORT_REPORT),  "",  CTEXT(T_HK_EXPORT_REPORT), MENU_FUNC menu_export_report, {NULL}, 0, 0},
    {CTEXT(T_EXPORT_ADIF),    "",  CTEXT(T_HK_EXPORT_ADIF), MENU_FUNC menu_export_adif, {NULL}, 0, 0},
    {CTEXT(T_EXPORT_HTML),    "",  CTEXT(T_HK_EXPORT_HTML), MENU_FUNC menu_export_html, {NULL}, 0, 0},
    {CTEXT(T_EXPORT_STATS),   "",  CTEXT(T_HK_EXPORT_STATS), MENU_FUNC menu_export_stats, {NULL}, 0 , 0},
    {CTEXT(T_EXPORT_TITLPAGE),"",  CTEXT(T_HK_EXPORT_TITLPAGE), MENU_FUNC menu_export_titlpage, {NULL}, 0 , 0},
    {"", "", M_BAR, NULL, {NULL}, 0, 0},
    {CTEXT(T_IMPORT_EDI),     "",  CTEXT(T_HK_IMPORT_EDI),  MENU_FUNC menu_import_edi,  {NULL}, 0, 0},
    {CTEXT(T_IMPORT_ADIF),    "",  CTEXT(T_HK_IMPORT_ADIF), MENU_FUNC menu_import_adif, {NULL}, 0, 0},
    {CTEXT(T_IMPORT_SWAP),    "",  CTEXT(T_HK_IMPORT_SWAP), MENU_FUNC menu_import_swap, {NULL}, 0, 0},
    {"", "", M_BAR, NULL, {NULL}, 0, 0},
    {CTEXT(T_CONTEST_OP),  "",  CTEXT(T_HK_CONTEST_OP), MENU_FUNC menu_contest1_options_from_ctest, {NULL}, 0, 0},
    {"", "", M_BAR, NULL, {NULL}, 0, 0},
    {CTEXT(T_CLOSE_CONTEST),     "",  CTEXT(T_HK_CLOSE_CONTEST), MENU_FUNC menu_contest_close, {NULL}, 0, 0},
    {NULL, NULL, 0, NULL, {NULL}, 0, 0}
};

void do_contest_menu(union cba_t cba)
{
    if (!ctest) do_menu(ctest_menu1, CBA0);
    else        do_menu(ctest_menu2, CBA0);
}
/************************* EDIT MENU *********************************/

struct menu_item edit_menu[] = {
    {CTEXT(T_ROTAR), "Alt+R", CTEXT(T_HK_ROTAR), MENU_FUNC menu_rotar, {NULL}, 0, 0},
    {CTEXT(T_ADD_ERROR), "", CTEXT(T_HK_ADD_ERROR),  MENU_FUNC menu_add_error, {NULL}, 0, 0},
    {CTEXT(T_CHOP), "Alt+O", CTEXT(T_HK_CHOP),  MENU_FUNC menu_chop, {NULL}, 0, 0},
    {CTEXT(T_CALL_INFO), "Alt+I", CTEXT(T_HK_CALL_INFO), MENU_FUNC call_info, {NULL}, 0, 0},
    {"", "", M_BAR, NULL, {NULL}, 0, 0},
    {CTEXT(T_SKED_QRG), "Alt+F", CTEXT(T_HK_SKED_QRG),  MENU_FUNC menu_skedqrg, {NULL}, 0, 0},
    {CTEXT(T_GRAB_BAND), "Alt+G", CTEXT(T_HK_GRAB_BAND),  MENU_FUNC menu_grabband, {NULL}, 0, 0},
    {CTEXT(T_FORCE_RUN), "", CTEXT(T_HK_FORCE_RUN),  MENU_FUNC menu_forcerun, {NULL}, 0, 0},
    {CTEXT(T_CH_SPY), "", CTEXT(T_HK_CH_SPY), MENU_FUNC menu_load_from_peer, (union cba_t)(void *)send_spypeer_request, 0, 0}, /* todo */
    {CTEXT(T_CH_ENDSPY), "", CTEXT(T_HK_CH_ENDSPY), MENU_FUNC menu_endspy, {NULL}, 0},
    {"", "", M_BAR, NULL, {NULL}, 0, 0},
    {CTEXT(T_RECAQRB), "", CTEXT(T_HK_RECAQRB),  MENU_FUNC menu_recalc_qrb, {NULL}, 0, 0},
    {CTEXT(T_CW_CTEST), "", CTEXT(T_HK_CW_CTEST),  MENU_FUNC menu_cw_update_contest, {NULL}, 0, 0},
    {CTEXT(T_CW_BAND), "", CTEXT(T_HK_CW_BAND),  MENU_FUNC menu_cw_update_band, {NULL}, 0, 0},
    {CTEXT(T_IMPORT_EBW), "", CTEXT(T_HK_IMPORT_EBW),  MENU_FUNC menu_import_ebw, {NULL}, 0, 0},
    {NULL, NULL, 0, NULL, {NULL}, 0, 0}
};
    
struct menu_item no_edit_menu[] = {
    {CTEXT(T_NO_CTEST), "", M_BAR, NULL, {NULL}, 0, 0},
    {NULL, NULL, 0, NULL, {NULL}, 0, 0}
};

void do_edit_menu(union cba_t cba)
{
    if (!ctest || !aband) do_menu(no_edit_menu, CBA0);
    else                  do_menu(edit_menu, CBA0);
}

/************************** SETUP MENU ************************************/

void menu_save_rc(union cba_t cba){
    gchar *filename;
    gchar *c;
    int ret;
    
    filename = g_strconcat(getenv("HOME"), "/tucnak/tucnakrc", NULL);
    ret=save_rc_file(filename);        
    if (ret) {
        c = g_strdup_printf(VTEXT(T_CANT_WRITE_S), filename);
        errbox(c, ret);
        g_free(c);
    }else{
        log_addf(VTEXT(T_SAVED_S), filename);
    }
    
    g_free(filename);

}

void do_peer_menu(void (* func)(union cba_t cba)){
    int i,max;
    struct menu_item *mi = NULL;
    gchar **items;

    items = g_strsplit(net->allpeers,";",0);
    max=0;
    for (i=0; items[i]!=NULL;i++){
        union cba_t cba2;
        
        if (strcmp(items[i],net->myid)==0) continue;
        if (strlen(items[i])==0) continue;

        if (!mi) if (!(mi = new_menu(3))) return;
        if (strlen(items[i])>max) max=strlen(items[i]);
        cba2.int_=i;
        add_to_menu(&mi,stracpy(items[i]),"", "", MENU_FUNC func, cba2, 0);    
    }
    g_strfreev(items);
    
    if (mi){
        set_window_ptr(gses->win, (term->x-max)/2,(term->y-2-i)/2);
        do_menu(mi, CBA0);
    }else
        errbox(VTEXT(T_NO_PEERS),0);
    return;
    
}

void do_peer_operators_menu(void (* func)(union cba_t cba)){
    int i,max;
    struct menu_item *mi = NULL;
    gchar **items,*c;

    items = g_strsplit(net->allpeers,";",0);
    max=0;
    for (i=0; items[i]!=NULL && items[i+1]!=NULL;i+=2){
        union cba_t cba2;
        
        if (strcmp(items[i],net->myid)==0) continue;
        if (strlen(items[i])==0) continue;

        if (!mi) if (!(mi = new_menu(3))) return;
        c=g_strdup_printf("%-8s %s", items[i+1], items[i]);
        if (strlen(c)>max) max=strlen(c);
        cba2.int_=i;
        add_to_menu(&mi,stracpy(c),"", "", MENU_FUNC func, cba2, 0);    
        g_free(c);
    }
    g_strfreev(items);
    
    if (mi){
        set_window_ptr(gses->win, (term->x-max)/2,(term->y-2-i)/2);
        do_menu(mi, CBA0);
    }else
        errbox(VTEXT(T_NO_PEERS),0);
    return;
}

void menu_load_from_peer(union cba_t cba){
    GString *gs;
    char *op;

    /*dbg("menu_load_from_peer\n"); */
    
    if (cmp_sin(&net->global, &net->my)==0) { /* i'm master */
        int i;
        struct conn *conn;
        
        /* LOOK ALSO net.c rel_write, dommand DO */
        
        CONDGFREE(net->allpeers);
        gs=g_string_sized_new(100);
        for (i=0;i<net->peers->len;i++){
            conn = (struct conn *)g_ptr_array_index(net->peers,i);
        
            if (!conn_prod_state(conn)) continue;
            op="---";
            if (ctest && aband && conn->operator) op=conn->operator;
            g_string_sprintfa(gs,"%s;%s;", conn->remote_id, op);
        }
        net->allpeers=g_strdup(gs->str);
        g_string_free(gs,TRUE);
        do_peer_operators_menu(cba.void_); /* todo */
        return;
    }
    
    /* i'm slave */
    if (!conn_prod_state(net->master)){
        errbox(VTEXT(T_NO_MASTER),0);  
        return;
    }

    net->peerfunc = cba.void_;/*todo */
    rel_write(net->master, "DO\n");
}

                                                                      
void contest_def(union cba_t cba);

struct menu_item setup_menu[] = {
    {CTEXT(T_CTEST_DEF), "", CTEXT(T_HK_CTEST_DEF), MENU_FUNC contest_def, {NULL}, 0, 0},
    {CTEXT(T_BAND_DEF), ">", CTEXT(T_HK_BAND_DEF), MENU_FUNC bands_menu, (union cba_t)(void*)menu_setup_band, 1, 0}, /* todo */
    {CTEXT(T_RESPOP), "", CTEXT(T_HK_RESPOP), MENU_FUNC menu_responsible_op, {NULL}, 0, 0},
    {CTEXT(T_CW_DAEMON), "", CTEXT(T_HK_CW_DAEMON), MENU_FUNC menu_cwda, {NULL}, 0, 0},
    {CTEXT(T_AUDIO), "", CTEXT(T_HK_AUDIO), MENU_FUNC menu_ssbd, {NULL}, 0, 0},
    {CTEXT(T_CW_CQ), ">", CTEXT(T_HK_CW_CQ), MENU_FUNC menu_cq_cw, {NULL}, 1, 0},
    {CTEXT(T_SSB_CQ), ">", CTEXT(T_HK_SSB_CQ), MENU_FUNC menu_cq_ssb, {NULL}, 1, 0},
    {CTEXT(T_AUTOSAVE), "", CTEXT(T_HK_AUTOSAVE), MENU_FUNC menu_autosave, {NULL}, 0, 0},
    {CTEXT(T_NETWORK), "", CTEXT(T_HK_NETWORK), MENU_FUNC menu_network, {NULL}, 0, 0},
    {CTEXT(T_MISCOPTS), "", CTEXT(T_HK_MISCOPTS), MENU_FUNC misc_opts, {NULL}, 0, 0},
    {CTEXT(T_TERMINAL_OPTIONS), "", CTEXT(T_HK_TERMINAL_OPTIONS), MENU_FUNC terminal_options, {NULL}, 0, 0},
    {CTEXT(T_LANGUAGE), ">", CTEXT(T_HK_LANGUAGE), MENU_FUNC menu_language_list, {NULL}, 1, 0},
    {CTEXT(T_CHARACTER_SET), ">", CTEXT(T_HK_CHARACTER_SET), MENU_FUNC charset_list, (union cba_t)1, 1, 0},
    {"", "", M_BAR, NULL, {NULL}, 0, 0},
    {CTEXT(T_LOAD_CFG_NET), "", CTEXT(T_HK_LOAD_CFG_NET), MENU_FUNC menu_load_from_peer, (union cba_t)(void*)send_config_request, 0, 0},/* todo */
    {CTEXT(T_LOAD_CW_NET), "", CTEXT(T_HK_LOAD_CW_NET), MENU_FUNC menu_load_from_peer, (union cba_t)(void*)send_cwdb_request, 0, 0},/* todo */
    {"", "", M_BAR, NULL, {NULL}, 0, 0},
    {CTEXT(T_SAVE_CFG), "", CTEXT(T_HK_SAVE_CFG), MENU_FUNC menu_save_rc, {NULL}, 0, 0},
    {NULL, NULL, 0, NULL, {NULL}, 0, 0}
};

void do_setup_menu(union cba_t cba)
{
    do_menu(setup_menu, CBA0);
}

struct menu_item main_menu[] = {
    {CTEXT(T_CONTEST), "", CTEXT(T_HK_CONTEST), MENU_FUNC do_contest_menu, {NULL}, 1, 1},
    {CTEXT(T_FILE), "", CTEXT(T_HK_FILE), MENU_FUNC do_file_menu, {NULL}, 1, 1},
    {CTEXT(T_EDIT), "", CTEXT(T_HK_EDIT), MENU_FUNC do_edit_menu, {NULL}, 1, 1},
    {CTEXT(T_BANDS), "", CTEXT(T_HK_BANDS), MENU_FUNC bands_menu, (union cba_t)(void*)menu_activate_band, 1, 1}, /* todo */
    {CTEXT(T_SUBWINS), "", CTEXT(T_HK_SUBWINS), MENU_FUNC subwins_menu, {NULL}, 1, 1},
    {CTEXT(T_SETUP), "", CTEXT(T_HK_SETUP), MENU_FUNC do_setup_menu, {NULL}, 1, 1},
    {CTEXT(T_HELP), "", CTEXT(T_HK_HELP), MENU_FUNC do_menu, (union cba_t)(void*)help_menu, 1, 1}, /* todo */
    {NULL, NULL, 0, NULL, {NULL}, 0, 0}
};

void activate_bfu_technology(int item)
{
    do_mainmenu(main_menu, CBA0, item);
}

/*struct history file_history = { 0, {&file_history.items, &file_history.items} };
struct history search_history = { 0, {&search_history.items, &search_history.items} };
  */
struct history load_swap_history = { 0, {&load_swap_history.items, &load_swap_history.items }};


void free_history_lists()
{
   /* free_list(file_history.items);
    free_list(search_history.items);*/
    
    free_list(load_swap_history.items);
}


/***************************** LOAD SWAP ***********************************/

#if 0

void load_swap(char *text){
    FILE *f;

    f = fopen(text, "rt");
    if (!f){
        msg_box(term, NULL, VTEXT(T_ERROR), AL_CENTER, VTEXT(T_CANT_READ), 
                NULL, 1, VTEXT(T_OK), NULL, B_ENTER | B_ESC);
        return;
    }
    
    add_qsos_from_swap(aband, f);
    fclose(f);
    
}


void menu_load_swap(union cba_t cba){
    input_field(ses->term, NULL, "Load swap", "Enter filename", 
            VTEXT(T_OK), VTEXT(T_CANCEL), ses, &load_swap_history, 
            MAX_INPUT_URL_LEN, "", 0, 0, NULL, 
            load_swap, NULL);
}
#endif


void menu_play_last(union cba_t cba){
    ssbd_play_last_sample(ssbd);
}
void menu_break_record(union cba_t cba){
    cq_abort(1);
}
