#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <list>

#include "tulip/GlFonts.h"

using namespace std;

GLuint GlFonts::base=0;
GLuint GlFonts::texture=0;
void * GlFonts::bitmapFont=GLUT_BITMAP_9_BY_15;
void * GlFonts::strokeFont=GLUT_STROKE_ROMAN;



void GlFonts::setBitmapFont(void *font) {GlFonts::bitmapFont=font;}
void GlFonts::setStrokeFont(void *font) {GlFonts::strokeFont=font;}
void GlFonts::setTextureFont(string fileName){
  if (GlFonts::texture != 0) GlFonts::killFont();
  GlFonts::load(fileName);
  GlFonts::buildFont();
}

/* Where The Printing Happens  */
void GlFonts::drawTextureString(const char *str) {
  glEnable(GL_TEXTURE_2D);
  glPushAttrib(GL_CULL_FACE);
  glDisable(GL_CULL_FACE);
  unsigned int length=strlen(str);
  list<int> endLine;
  int cur=0;
  bool decal=false;
  for (unsigned int i=0;i<length;++i)
    if ((str[i]=='\n')) {endLine.push_back(i);decal=true;}
  endLine.push_back(length);
  glBindTexture(GL_TEXTURE_2D, texture);	/* Select Our Font Texture  */
  glListBase(base-32);		/* Choose The Font Set (0 or 1)  */
  unsigned int x,y;
  GlFonts::getTextureStringSize(str,x,y);
  if (!decal) 
    glTranslatef(-(double)x/2.0,-(double)y/2.0,0);
  else 
    glTranslatef(-(double)x/2.0,+(double)y/2.0,0);
  while(!endLine.empty()) {
    int index=endLine.front();
    endLine.pop_front();
    glCallLists(index-cur,GL_BYTE,&str[cur]);
    glTranslated(-(index-cur)*16,-14,0);
    cur=index+1;
  }
  glPopAttrib();
  glDisable(GL_TEXTURE_2D);
}

void GlFonts::drawBitmapString(const char *str)
{
  int len=strlen(str);
  glBitmap(0,0,0,0,-len/2*9,-7,0);
  for (int i = 0; str[i]; i++) glutBitmapCharacter(bitmapFont, str[i]);
}
void GlFonts::drawStrokeString(const char *str)
{ 
  for (int i = 0; str[i]; ++i) glutStrokeCharacter(strokeFont, str[i]);
}
double GlFonts::getStrokeLength(const char *str){
  return glutStrokeLength(strokeFont,(unsigned char *)str);
}
void GlFonts::getTextureStringSize(const char *str,unsigned int &w,unsigned int &h){
  unsigned int length=strlen(str);
  w=0;
  h=1;
  unsigned int cur=0;
  for (unsigned int i=0;i<length;++i) 
    if ((str[i]=='\n')) {
      h++;
      if ((i-cur)>w) w=i-cur;
      cur=i;
    }
  if (w==0) w=length;
  w*=16;
  h*=16;
}
unsigned int GlFonts:: getint(FILE *fp)
{
  int c, c1, c2, c3;

  /* get 4 bytes */
  c = getc(fp);  
  c1 = getc(fp);  
  c2 = getc(fp);  
  c3 = getc(fp);
  
  return ((unsigned int) c) +   
    (((unsigned int) c1) << 8) + 
    (((unsigned int) c2) << 16) +
    (((unsigned int) c3) << 24);
}
unsigned int GlFonts::getshort(FILE *fp)
{
  int c, c1;
  
  /*get 2 bytes  */
  c = getc(fp);  
  c1 = getc(fp);

  return ((unsigned int) c) + (((unsigned int) c1) << 8);
}
int GlFonts::imageLoad(char *filename, Image *image) 
{
  FILE *file;
  unsigned long size;                 /* size of the image in bytes.  */
  unsigned long i;                    /* standard counter.  */
  unsigned short int planes;          /* number of planes in image (must be 1)   */
  unsigned short int bpp;             /* number of bits per pixel (must be 24)  */
  char temp;                          /* used to convert bgr to rgb color.  */
  /* make sure the file is there.  */
  if ((file = fopen(filename, "rb"))==NULL) {
    printf("File Not Found : %s\n",filename);
    return 0;
  }
  /* seek through the bmp header, up to the width/height:  */
  fseek(file, 18, SEEK_CUR);
  /* No 100% errorchecking anymore!!!  */
  /* read the width  */
  image->sizeX = getint (file);
  /* printf("Width of %s: %lu\n", filename, image->sizeX);*/
  /* read the height   */
  image->sizeY = getint (file);
  /*    printf("Height of %s: %lu\n", filename, image->sizeY);*/
  /* calculate the size (assuming 24 bits or 3 bytes per pixel).  */
  size = image->sizeX * image->sizeY * 3;
  /* read the planes  */
  planes = getshort(file);
  if (planes != 1) {
    printf("Planes from %s is not 1: %u\n", filename, planes);
    return 0;
  }
  /* read the bpp  */
  bpp = getshort(file);
  if (bpp != 24) {
    printf("Bpp from %s is not 24: %u\n", filename, bpp);
    return 0;
  }
  /* seek past the rest of the bitmap header.  */
  fseek(file, 24, SEEK_CUR);
  /* read the data.   */
  image->data = (char *) malloc(size);
  if (image->data == NULL) {
    printf("Error allocating memory for color-corrected image data");
    return 0;	
  }
  if ((i = fread(image->data, size, 1, file)) != 1) {
    printf("Error reading image data from %s.\n", filename);
    return 0;
  }
  for (i=0;i<size;i+=3) { /* reverse all of the colors. (bgr -> rgb)  */
    temp = image->data[i];
    image->data[i] = image->data[i+2];
    image->data[i+2] = temp;
  }
  /* we're done.  */
  return 1;
}

/* Load Bitmaps And Convert To Textures  */
bool GlFonts::load(string fileName) {
  Image *TextureImage;
  TextureImage = (Image *) malloc(sizeof(Image));
  if (!GlFonts::imageLoad((char *)fileName.c_str(), TextureImage)) {
    cerr <<"Erreur Load" << endl;
    free(TextureImage);
    return false;
  }
  glGenTextures(1, &GlFonts::texture);
  glBindTexture(GL_TEXTURE_2D, GlFonts::texture);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
  glTexImage2D(GL_TEXTURE_2D, 0, 3, TextureImage->sizeX, 
	       TextureImage->sizeY, 0, GL_RGB, GL_UNSIGNED_BYTE,
	       TextureImage->data);
  free(TextureImage);
  return true;
}

/* Build Our Font Display List  */
void GlFonts::buildFont() {
  float	cx;				/* Holds Our X Character Coord  */
  float	cy;				/* Holds Our Y Character Coord  */
  base=glGenLists(256);				/* Creating 256 Display Lists  */
  glBindTexture(GL_TEXTURE_2D, texture);	/* Select Our Font Texture  */
  for (unsigned int loop=0; loop<256; loop++)	/* Loop Through All 256 Lists  */
    {
      cx=(float)(loop%16)/16.0f;	/* X Position Of Current Character  */
      cy=(float)(loop/16)/16.0f;	/* Y Position Of Current Character  */
      glNewList(base+loop,GL_COMPILE);	/* Start Building A List  */
      glBegin(GL_QUADS);		/* Use A Quad For Each Character  */
      glTexCoord2f(cx,1-cy-0.0625f);	/* Texture Coord (Bottom Left)  */
      glVertex3i(0,0,0);			/* Vertex Coord (Bottom Left)  */
      glTexCoord2f(cx+0.0625f,1-cy-0.0625f);	/* Texture Coord (Bottom Right)  */
      glVertex3i(16,0,0);			/* Vertex Coord (Bottom Right)  */
      glTexCoord2f(cx+0.0625f,1-cy);	/* Texture Coord (Top Right)  */
      glVertex3i(16,16,0);		/* Vertex Coord (Top Right)  */
      glTexCoord2f(cx,1-cy);		/* Texture Coord (Top Left)  */
      glVertex3i(0,16,0);			/* Vertex Coord (Top Left)  */
      glEnd();				/* Done Building Our Quad (Character)  */
      glTranslated(16,0,0);		/* Move To The Right Of The Character  */
      glEndList();			/* Done Building The Display List  */
    }					/* Loop Until All 256 Are Built  */
}

void GlFonts::killFont()	
{
  glDeleteLists(base,256);	/* Delete All 256 Display Lists  */
}
