#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cmath>

#include <tulip/Coord.h>
#include "tulip/GlGraph.h"
#include <GL/gl.h>
#include <GL/glu.h>

Coord GlGraph::getSceneTranslation() const {
  return sceneTranslation;
}
void GlGraph::setSceneTranslation(const Coord &c){
  TRACE_EXEC(); 
  sceneTranslation=c;
}
Coord GlGraph::getSceneRotation() const {
  return sceneRotation;
}
void GlGraph::setSceneRotation(const Coord &c) {
  TRACE_EXEC(); 
  sceneRotation=c;
}
void GlGraph::translateCamera(const int x, const int y, const int z) {  
  double x0=0,y0=0,z0=0;
  double x1=x,y1=y,z1=z;
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glLoadIdentity();
  gluLookAt(cameraEyes[0],cameraEyes[1],cameraEyes[2], cameraCenter[0],cameraCenter[1],cameraCenter[2],cameraUp[0],cameraUp[1],cameraUp[2]); 
  changeCoord(x0,y0,z0);
  changeCoord(x1,y1,z1);
  glPopMatrix();
  Coord tmp=Coord(x1-x0,(y1-y0),(z1-z0));
  cameraEyes+=tmp;
  cameraCenter+=tmp;
  strategy->toUpdate=true;
  strategy->UpdateGL();
}
//==========================================================
void GlGraph::zoom(int step) {
  strategy->toUpdate=true;
  int signeZ = (step < 0) ? -1 : 1;
  if (step<0) step=-step;
  if (signeZ>0)
    cameraZoomFactor*=pow(1.1,step);
  else
    cameraZoomFactor/=pow(1.1,step);
  strategy->toUpdate=true;
  strategy->UpdateGL();
}
//================================================
void GlGraph::rotateScene(const int x, const int y, const int z) {
  sceneRotation+=Coord(2*x,2*y,2*z);
  strategy->toUpdate=true;
  strategy->UpdateGL();  
}

#include <iostream>
//==================================================
void GlGraph::zoomXY(int step, const int x, const int y)
{
  int signeZ = (step < 0) ? -1 : 1;
  /* translation factor:
   * the farther from the center of the screen, the higher the factor (and the higher the resulting translation)
   */
  if (step<0) step=-step;
  int factX = step*(winW/2-x)/ 7;
  int factY = step*(winH/2-y)/ 7;
  if (signeZ>0)
    cameraZoomFactor*=pow(1.1,step);
  else
    cameraZoomFactor/=pow(1.1,step);
  translateCamera(factX,-factY,0);
}
