//-*-c++-*-
/**
 Author: David Auber
 Email : auber@labri.fr
 Last modification : 01/09/2003
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#include <tulip/Iterator.h>
#include <tulip/SuperGraph.h>
#include <list>

#ifndef TULIP_NODEMAPITERATOR_H
#define TULIP_NODEMAPITERATOR_H

///Interface of Iterators
struct NodeMapIterator : public Iterator<node> {
  ///
  NodeMapIterator(SuperGraph *sg, node source, node target) {
    assert(cloneIt.empty());
    bool start=true;
    Iterator<node> *itIn=sg->getInOutNodes(target);
    for (;itIn->hasNext();) {
      node tmp=itIn->next();
      if ((start) && (tmp==source)) {
	start=false;
	itStl=cloneIt.begin();
      }
      else {
	if (start)
	  cloneIt.push_back(tmp);
	else 
	  cloneIt.insert(itStl,tmp);
      }
    } delete itIn;
    itStl=cloneIt.begin();
  }
  ///
  ~NodeMapIterator(){};
  ///Return the next element
  node next() {
    node tmp=*itStl;
    ++itStl;
    return tmp;
  }
  ///Return true if it exist a next element
  bool hasNext() {
    return (itStl!=cloneIt.end());
  }
  
private :
  std::list<node> cloneIt;
  std::list<node>::iterator itStl;
};

struct EdgeMapIterator : public Iterator<edge> {
  ///
  EdgeMapIterator(SuperGraph *sg, edge source, node target) {
    assert(cloneIt.empty());
    bool start=true;
    Iterator<edge> *itIn=sg->getInOutEdges(target);
    for (;itIn->hasNext();) {
      edge tmp=itIn->next();
      if (start && tmp==source) {
	start=false;
	itStl=cloneIt.begin();
      }
      else {
	if (start)
	  cloneIt.push_back(tmp);
	else 
	  cloneIt.insert(itStl,tmp);
      }
    } delete itIn;
    itStl=cloneIt.begin();
  }
  ///
  ~EdgeMapIterator(){};
  ///Return the next element
  edge next() {
    edge tmp=*itStl;
    ++itStl;
    return tmp;
  }
  ///Return true if it exist a next element
  bool hasNext() {
    return (itStl!=cloneIt.end());
  }
  
private :
  std::list<edge> cloneIt;
  std::list<edge>::iterator itStl;
};


#endif
