//-*-c++-*-
#ifndef TULIP_METAGRAPHPROXY_H
#define TULIP_METAGRAPHPROXY_H

#include "PropertyProxy.h"
#include "MethodFactory.h"
#include "TemplateFactory.h"

class PropertyContext;

///
class MetaGraphProxy:public PropertyProxy<MetaGraphType,MetaGraphType>
{ 
  ///
  friend class MetaGraph;

public:
  static TemplateFactory<MetaGraphFactory,MetaGraph,PropertyContext *> factory;

private:
  ///
  MetaGraph *currentMetaGraph;

public :
  ///
  MetaGraphProxy (PropertyContext *context);
  ///
  ~MetaGraphProxy();
  ///
  bool select(std::string , std::string &);
  ///
  void reset_handler();
  ///
  void recompute_handler();
  ///
  void clone_handler(PropertyProxy<MetaGraphType,MetaGraphType> &);
};

#endif

