#ifndef _TULIPREFLECT
#define _TULIPREFLECT
#include <iostream>
#include <string>
#include <cassert>
#include <typeinfo>
#include "StlIterator.h"

struct DataType {
  DataType(){}
  DataType(void *value,const std::string typeName):value(value),typeName(typeName){}
  void * value;
  std::string typeName;
};

//This class enables to define a structure
struct StructDef {
  //Add the variable of type T and name str in the structure.
  template<typename T> void add(std::string str);
  //Get iterator on structure fields
  Iterator< std::pair<std::string,std::string> >* getField();
  //Remove the variable which have str has name in the structure.
  void erase(std::string str);
private:
  std::map<std::string,std::string> data;
};

/**  A container which allows insertion of different type.
     The inserted data must have a copy-constructor well done */
struct DataSet {
  /**Return a copy of the value of the variable with name str.
     Type are checked in Debug Mode.
     If the variable str doesn't exist return false else true. */
  template<typename T> bool get(const std::string str,T& value) const;
  /**Return a copy of the value of the variable with name str.
     Type are checked in Debug Mode.
     If the variable str doesn't exist return false else true.
     The data is removed after the call. */
  template<typename T> bool getAndFree(const std::string &str,T& value);
  /** Set the value of the variable str.*/
  template<typename T> void set(const std::string &str,const T& value);
  /**return true if str exists else false.*/
  bool exist(const std::string &str);
private:
  std::map<std::string,DataType> data;
};

#include "cxx/Reflect.cxx"

#endif
