//-*-c++-*-
#ifndef TYPES_H
#define TYPES_H

#include <vector>
#include <string>
#include <list>
#include <float.h>
#include "Coord.h"
#include "Size.h"
#include "Color.h"
class SuperGraph;
///
class Type {
public:
  Type(){};
  ~Type();
};

class MetaGraphType:public Type {
public:
  typedef SuperGraph* RealType;
  static MetaGraphType::RealType undefineValue() {return 0;}
  static MetaGraphType::RealType defaultValue() {return 0;}
  static void  del(MetaGraphType::RealType element){}
};

///
class DoubleType:public Type {
public:
  typedef double RealType;
  static double undefineValue() {return DBL_MIN;}
  static double defaultValue() {return 0;}
  static void  del(DoubleType::RealType element){}
};

///
class IntType:public Type
{
public:
  typedef int RealType;
  static int undefineValue() {return INT_MIN;}
  static int defaultValue() {return 0;}
  static void  del(IntType::RealType element){}
};

///
class BooleanType:public Type {
public:
  typedef bool RealType;
  static bool undefineValue() {return false;}
  static bool defaultValue() {return false;}
  static void del(BooleanType::RealType element){}
};

///
class LineType:public Type
{
public:
  typedef std::vector<Coord> RealType;
  static std::vector<Coord> undefineValue() {
    std::vector<Coord> tmp;
    return tmp;
  }
  static std::vector<Coord> defaultValue() {
    std::vector<Coord> tmpList;
    return tmpList;
  }
  static void del(LineType::RealType &element){element.clear();}
};

///
class PointType:public Type {
public:
  typedef  Coord RealType;
  static Coord undefineValue() {
    Coord tmp;
    tmp.set(DBL_MIN,DBL_MIN,DBL_MIN);
    return tmp;
  }
  static Coord defaultValue() {
    Coord tmp;
    tmp.set(rand()%1024,rand()%1024,rand()%1024);
    return tmp;
  }
  static void del(PointType::RealType element){}
};

///
class SizeType:public Type {
public:
  typedef  Size RealType;
  static Size undefineValue() {
    return Size(DBL_MIN,DBL_MIN,DBL_MIN);
  }
  static Size defaultValue() {
    return Size(1,1,0);
  }
  static void del(SizeType::RealType element){}
};

///
class StringType:public Type {
public:
  typedef std::string RealType;
  static std::string undefineValue() 
    {return std::string("");}
  static std::string defaultValue()
  {return std::string("");}
  static void del(StringType::RealType element){}
};

///
class ColorType:public Type {
public:
  typedef Color RealType;
  static Color undefineValue() 
  {return Color(255,255,255,255);}
  static Color defaultValue()
  {return Color();}
  static void del(ColorType::RealType element){}
};

#endif









