//-*-c++-*-
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include "tulip/Cluster.h"

using namespace std;
//-----------------------------------------
Cluster::Cluster()
{
  rootSubGraph=new SubGraph();
  rootSubGraph->setName("root");
  rootSubGraph->setFather(rootSubGraph);
  lSubGraph.push_front(rootSubGraph);
}
//-----------------------------------------
Cluster::~Cluster()
{delete rootSubGraph;}
//-----------------------------------------
//move the subgraph two the level upper
//it will be the soon of its grand Father
void Cluster::moveUp(SubGraph *p)
{
  if (p->getFather()!=p)
    if (p->getFather()->getFather()!=p->getFather())
      {
	SubGraph*father=p->getFather();
	SubGraph*gfather=father->getFather();
	father->getSubGraphChildren()->remove(p);
	gfather->addSubGraphChild(p);
	p->setFather(gfather);
      }
}
//-----------------------------------------
void Cluster::recEraseChildren(SubGraph *p,SubGraph *p2)
{
  string s( p->getName());
#ifndef NDEBUG
  cerr << " Cluster::recEraseChildren(SubGraph *p,*p2):" << s << endl;
#endif
  list<SubGraph *> *fils=p->getSubGraphChildren();
  list<SubGraph *>::iterator lit;
  for (lit=fils->begin();lit!=fils->end();++lit)
    {
       recEraseChildren(*lit,p2);
    }
  if (p!=p2)
    {
      lSubGraph.remove(p);
      delete p;
    }
  else
    {
      p->getSubGraphChildren()->clear();
    }
  //cerr << " Cluster::recErase(SubGraph *p) Ok:"<< s << endl;
}
//-----------------------------------------
//Dtruit la subGraph et remet  jours le Dag
void Cluster::recErase(SubGraph *p)
{
#ifndef NDEBUG
  cerr << "cluster rec erase" << endl <<  "subgraph: ";
#endif
  string s( p->getName());
  //  cerr << s << endl;
  list<SubGraph *> *fils=p->getSubGraphChildren();
  while(!fils->empty())
    {
       recErase(fils->front());
    }
  erase(p);
#ifndef NDEBUG
  cerr << " Cluster::recErase(SubGraph *p) Ok:"<< s << endl;
#endif
}
//-----------------------------------------
void Cluster::erase(SubGraph *p)
{
  string s( p->getName());
#ifndef NDEBUG
  cerr << "Cluster::erase :"  << s << endl;
#endif
  SubGraph *tmpFather;
  if ((tmpFather=p->getFather())==p) return;
  list<SubGraph *>::iterator lit;
  for (lit=p->getSubGraphChildren()->begin();lit!=p->getSubGraphChildren()->end();++lit)
    {
      (*lit)->setFather(tmpFather);
      tmpFather->addSubGraphChild(*lit);
    }
  p->getSubGraphChildren()->clear();
  tmpFather->subSubGraphChild(p);
#ifndef NDEBUG
  cerr << "Cluster::erase Ok:"<< s << endl;
#endif
}
//-----------------------------------------
//Construit une SubGraph et vrifie le Dag
SubGraph *Cluster::createSubGraph(const string &s, SubGraph* p, SelectionProxy *sP)
{
  //Il faut inserrer la verification pout tout element doit etre element de p 
  SubGraph *newSubGraph=new SubGraph();
  newSubGraph->setName(s);
  newSubGraph->setSubGraphProxy(sP);
  newSubGraph->setFather(p);
  lSubGraph.push_back(newSubGraph);
  p->addSubGraphChild(newSubGraph);
  return newSubGraph;
}
//-----------------------------------------
SubGraph *Cluster::getRootSubGraph()
{return rootSubGraph;}











