#include "tulip/GraphMeasure.h"
#include "tulip/Reflect.h"
#include "tulip/SuperGraph.h"
#include "tulip/MetricProxy.h"


#include <list>
using namespace std;

//Warning the algorithm is not optimal
double TlpTools::averagePathLength(SuperGraph *sg) {
  list<node> fifo;
  double sumPath=0;

  MetricProxy *mark=getLocalProxy<MetricProxy>(sg,"length");
  Iterator<node>*itN=sg->getNodes();
  for (;itN->hasNext();) {
    mark->setAllNodeValue(0);
    node itn=itN->next();
    fifo.clear();
    fifo.push_back(itn);
    while(!fifo.empty()) {
      node current=fifo.front();
      fifo.pop_front();
      Iterator<node> *itNei=sg->getInOutNodes(current);
      for (;itNei->hasNext();) {
	node nei=itNei->next();
	if (mark->getNodeValue(nei)==0 && nei!=itn)  {
	  mark->setNodeValue(nei,mark->getNodeValue(current)+1);
	  sumPath+=mark->getNodeValue(current)+1;
	  fifo.push_back(nei);
	}
      } delete itNei;
    }
  } delete itN;
  sg->getPropertyProxyContainer()->delLocalProxy("length");
  return sumPath/(sg->numberOfNodes()*(sg->numberOfNodes()-1));
}

double  TlpTools::averageCluster(SuperGraph *sg) {
  DataSet data;
  data.set("depth",1);
  bool cache,result;
  string errMsg;
  MetricProxy *cluster=getLocalProxy<MetricProxy>(sg,"Cluster",cache,result,errMsg,0,&data);
  Iterator<node>*itN=sg->getNodes();
  double sum=0;
  for (;itN->hasNext();)
    sum+=cluster->getNodeValue(itN->next());
  delete itN;
  sg->getPropertyProxyContainer()->delLocalProxy("Cluster");
  return sum/=sg->numberOfNodes();
}
