//-*-c++-*-
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <float.h>
#include "tulip/IntProxy.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/Int.h"
#include "tulip/PropertyProxy.h"
#include "tulip/MethodFactory.h"

using namespace std;

TemplateFactory<IntFactory,Int,PropertyContext *> IntProxy::factory;
//==============================
///Constructeur d'un IntProxy
IntProxy::IntProxy (PropertyContext *context):PropertyProxy<IntType,IntType>(context)
{
  minMaxOk=false;
  currentInt=NULL;
  propertyProxy=this;
}
//==============================
///Destructeur d'un int Proxy  
///Vide pour l'instant, cela peut
///provoquer des fuites mmoires
IntProxy::~IntProxy() 
{
}    
//====================================================================
///Renvoie le minimum de la mtrique associ aux noeuds du IntProxy
int IntProxy::getNodeMin() 
{
  if (!minMaxOk) 
    computeMinMax();
  return minN;
}
//====================================================================
///Renvoie le maximum de la mtrique associ aux noeuds du IntProxy
int IntProxy::getNodeMax() 
{
  if (!minMaxOk) 
    computeMinMax();
  return maxN;
}
//====================================================================
///Renvoie le Minimum de la mtrique associ aux artes du IntProxy
int IntProxy::getEdgeMin() 
{
  if (!minMaxOk) 
    computeMinMax();
  return minE;
}
//====================================================================
///Renvoie le Maximum de la mtrique associ aux artes du IntProxy
int IntProxy::getEdgeMax() 
{
  if (!minMaxOk) 
    computeMinMax();
  return maxE;
}
//========================================================================
///Fonction permettnet de changer la Int:public Property du IntProxy
bool IntProxy::select(string s,string &s2)
{
  Observable::holdObservers();
  //  context.superGraph=superGraph;
  context.propertyProxy=this;
  Int *tmpInt=factory.getObject(s,&context);
  bool   result;
  if (tmpInt!=NULL)
    {
      result=tmpInt->check(s2);
      if (currentInt!=NULL) delete currentInt;
      currentInt=tmpInt;
      changeCurrentProperty(currentInt,s);
      if (result)
	{
	  reset();
	  currentInt->run();
	}
    }
  else
    {
      s2="Data int enable";
      result=true;
    }
  notifyObservers();
  Observable::unholdObservers();
  return result;
}
//=========================================================
///Calcul le min et le Max de la mtrique associ au proxy
///Attention, la gestion du mim et max des artes n'est pas 
///assur ici et doit tre ajout ultrieurement
void IntProxy::computeMinMax()
{
  //cerr << "Compute Min Max" << endl;
  int tmp;
  Iterator<node> *itN=superGraph->getNodes();
  if (itN->hasNext()) {
    node itn=itN->next();
    tmp=getNodeValue(itn);
    maxN=tmp;
    minN=tmp;
  }
  for (;itN->hasNext();) {
    node itn=itN->next();
    tmp=getNodeValue(itn);
    if (tmp>maxN) maxN=tmp;
    if (tmp<minN) minN=tmp;
  }
  delete itN;
  Iterator<edge> *itE=superGraph->getEdges();
  if (itE->hasNext()) {
    edge ite=itE->next();
    tmp=getEdgeValue(ite);
    maxE=tmp;
    minE=tmp;
  }
  for (;itE->hasNext();) {
    edge ite=itE->next();
    tmp=getEdgeValue(ite);
    if (tmp>maxE) maxE=tmp;
    if (tmp<minE) minE=tmp;
  }
  delete itE;
  minMaxOk=true;
}
//=============================================================================
///Poign permettnet le reset des variables du IntProxy par le PropertyProxy
void IntProxy::reset_handler()
{
  minMaxOk=false;
}
//=============================================================================
///Poign permettnet le recompute il faut absolument mettre le graphProperties
///currentIntProxy  this sinon le rsultat est imprvisible
void IntProxy::recompute_handler()
{
  superGraph->getPropertyProxyContainer()->currentPropertyProxy=this;
  minMaxOk=false;
}
//=================================================================================
void IntProxy::clone_handler(PropertyProxy<IntType,IntType> &proxyC)
{
  if (typeid(this)==typeid(&proxyC))
    {
      IntProxy *proxy=(IntProxy *)&proxyC;
      minMaxOk=proxy->minMaxOk;
      if (minMaxOk)
	{
	  minE=proxy->minE;
	  maxE=proxy->maxE;
	  minN=proxy->minN;
	  maxN=proxy->maxN;
	}
    }
  else
    {
      minMaxOk=false;
    }
}








