#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <float.h>
#include "tulip/MetaGraphProxy.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/MetaGraph.h"
#include "tulip/PropertyProxy.h"
#include "tulip/MethodFactory.h"

using namespace std;

TemplateFactory<MetaGraphFactory,MetaGraph,PropertyContext *> MetaGraphProxy::factory;
//==============================
///Constructeur d'un MetaGraphProxy
MetaGraphProxy::MetaGraphProxy (PropertyContext *context) : 
  PropertyProxy<MetaGraphType,MetaGraphType>(context),
  currentMetaGraph(NULL)
{propertyProxy=this;}
//==============================
///Destructeur d'un metaGraph Proxy  
///Vide pour l'instant, cela peut
///provoquer des fuites mmoires
MetaGraphProxy::~MetaGraphProxy() {}    
//========================================================================
///Fonction permettnet de changer la MetaGraph:public Property du MetaGraphProxy
bool MetaGraphProxy::select(string s,string &s2)
{
  Observable::holdObservers();
  context.propertyProxy=this;
  MetaGraph *tmpMetaGraph=factory.getObject(s,&context);
  bool result;
  if (tmpMetaGraph!=NULL) {
    result=tmpMetaGraph->check(s2);
    if (currentMetaGraph!=NULL) delete currentMetaGraph;
    currentMetaGraph=tmpMetaGraph;
    changeCurrentProperty(currentMetaGraph,s);
    if (result)	{
      reset();
      currentMetaGraph->run();
    }
  }
  else {
    s2="Data metaGraph enable";
    result=true;
  }
  notifyObservers();
  Observable::unholdObservers();
  return result;
}
//=============================================================================
///Poign permettnet le reset des variables du MetaGraphProxy par le PropertyProxy
void MetaGraphProxy::reset_handler(){}
//=============================================================================
///Poign permettnet le recompute il faut absolument mettre le graphProperties
///currentMetaGraphProxy  this sinon le rsultat est imprvisible
void MetaGraphProxy::recompute_handler()
{
  superGraph->getPropertyProxyContainer()->currentPropertyProxy=this;
}
//=================================================================================
void MetaGraphProxy::clone_handler(PropertyProxy<MetaGraphType,MetaGraphType> &proxyC)
{}









