//-*-c++-*-
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <float.h>
#include "tulip/SizesProxy.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/Sizes.h"
#include "tulip/PropertyProxy.h"
#include "tulip/MethodFactory.h"

using namespace std;

TemplateFactory<SizesFactory,Sizes,PropertyContext *> SizesProxy::factory;
//==============================
SizesProxy::SizesProxy (PropertyContext *context):
  PropertyProxy<SizeType,SizeType>(context) {
  currentSizes=NULL;
  propertyProxy=this;
}
//==============================
SizesProxy::~SizesProxy() 
{}    
//====================================================================
///Fonction permettnet de changer la Sizes:public Property du SizesProxy
bool SizesProxy::select(string s,string &s2) {
  Observable::holdObservers();
  context.propertyProxy=this;
  Sizes *tmpSizes=factory.getObject(s,&context);
  bool   result;
  if (tmpSizes!=NULL) {
    result=tmpSizes->check(s2);
    if (currentSizes!=NULL) delete currentSizes;
    currentSizes=tmpSizes;
    changeCurrentProperty(currentSizes,s);
    if (result) {
      reset();
      currentSizes->run();
    }
  }
  else {
    s2="Data sizes enable";
    result=true;
  }
  notifyObservers();
  Observable::unholdObservers();
  return result;
}
//=============================================================================
void SizesProxy::reset_handler() {
}
//=============================================================================
void SizesProxy::recompute_handler() {
  superGraph->getPropertyProxyContainer()->currentPropertyProxy=this;
}


Size SizesProxy::getMax(SuperGraph *sg) {
  if (sg==0) sg=superGraph;
  int sgi=(int)sg;
  if (minMaxOk.find(sgi)==minMaxOk.end()) minMaxOk[sgi]=false;
  if (!minMaxOk[sgi]) computeMinMax(sg);
  return max[sgi];
}

Size  SizesProxy::getMin(SuperGraph *sg) {
  if (sg==0) sg=superGraph;
  int sgi=(int)sg;
  if (minMaxOk.find(sgi)==minMaxOk.end()) minMaxOk[sgi]=false;
  if (!minMaxOk[sgi]) computeMinMax(sg);
  return min[sgi];
}

void SizesProxy::computeMinMax(SuperGraph *sg) {
#ifndef NDEBUG
  cerr << "SizeqProxy::computeMinMax begin" << endl;
#endif

  Size tmpSize;
  Size maxS,minS;

  Iterator<node> *itN=sg->getNodes();
  if  (itN->hasNext()) {
    node itn=itN->next();
    tmpSize=getNodeValue(itn);
    for (int i=0;i<3;++i) {
      maxS[i]=tmpSize[i];
      minS[i]=tmpSize[i];
    }
  }
  for (;itN->hasNext();) {
    node itn=itN->next();
    tmpSize=getNodeValue(itn);
    for (int i=0;i<3;++i) {
      maxS[i]=maxS[i]>?tmpSize[i];
      minS[i]=minS[i]<?tmpSize[i];
    }
  }delete itN;

  if (sg==0) sg=superGraph;
  int sgi=(int)sg;

  minMaxOk[sgi]=true;  
  min[sgi]=minS;
  max[sgi]=maxS;
  //  cerr << "SizesProxy::computeMinMax end" << endl;
}
void SizesProxy::resetMinMax() {
  STL_EXT_NS::hash_map<int,bool>::iterator it;
  for (it=minMaxOk.begin();it!=minMaxOk.end();++it)
    it->second=false;
}
void SizesProxy::setNodeValue_handler(const node n){resetMinMax();}
void SizesProxy::setEdgeValue_handler(const edge e){resetMinMax();}
void SizesProxy::setAllNodeValue_handler(){resetMinMax();}
void SizesProxy::setAllEdgeValue_handler(){resetMinMax();}




