//-*-c++-*-
#include <cmath>

#if (__GNUC__ < 3)
#include <hash_map>
#else
#include <ext/hash_map>
#endif

#include <tulip/TulipPlugin.h>
#include <tulip/Color.h>

using namespace std;
///
inline float MIN(float a,float b) {
  return (a<b ? a : b);
}
inline float MAX(float a,float b) {
  return (a>b ? a : b);
}
void RGBtoHSV( float r, float g, float b, float *h, float *s, float *v )
{
  float min, max, delta;
  min = MIN( MIN( r, g) , b );
  max = MAX( MAX( r, g) , b );
  *v = max;                               // v
  delta = max - min;
  if( max != 0 )
    *s = delta / max;               // s
  else {
    // r = g = b = 0                // s = 0, v is undefined
    *s = 0;
    *h = -1;
    return;
  }
  if( r == max )
    *h = ( g - b ) / delta;         // between yellow & magenta
  else if( g == max )
    *h = 2 + ( b - r ) / delta;     // between cyan & yellow
  else
    *h = 4 + ( r - g ) / delta;     // between magenta & cyan
  *h *= 60;                               // degreesxk
  if( *h < 0 )
    *h += 360;
}

void HSVtoRGB( float *r, float *g, float *b, float h, float s, float v )
{
        int i;
        float f, p, q, t;
        if( s == 0 ) {
                // achromatic (grey)
                *r = *g = *b = v;
                return;
        }
        h /= 60;                        // sector 0 to 5
        i = (int)floor( h );
        f = h - (float)i;                      // factorial part of h
        p = v * ( 1 - s );
        q = v * ( 1 - s * f );
        t = v * ( 1 - s * ( 1 - f ) );
        switch( i ) {
	case 0:
	  *r = v;
	  *g = t;
	  *b = p;
	  break;
	case 1:
	  *r = q;
	  *g = v;
	  *b = p;
	  break;
	case 2:
	  *r = p;
	  *g = v;
	  *b = t;
	  break;
	case 3:
	  *r = p;
	  *g = q;
	  *b = v;
	  break;
	case 4:
	  *r = t;
	  *g = p;
	  *b = v;
	  break;
	default:                // case 5:
	  *r = v;
	  *g = p;
	  *b = q;
	  break;
        }
}

class LinearMapping:public Colors
{ 
private:
  MetricProxy *entryMetric;

public:
  LinearMapping(PropertyContext *context):Colors(context){}
  ~LinearMapping(){}
  
  Color getNodeValue(const node n) {
    entryMetric=getProxy<MetricProxy>(superGraph,"viewMetric");
    double min,max;
    min=entryMetric->getNodeMin();
    max=entryMetric->getNodeMax();
    float h,s,v;
    float r,g,b;
    v=1;
    s=1;
    double dd=entryMetric->getNodeValue(n)-min;
    h=55+dd*300/(max-min);
    HSVtoRGB(&r,&g,&b,h,s,v);
    return Color((int)(r*255.0f),(int)(g*255.0f),(int)(b*255.0f),0);
  }

  Color getEdgeValue(const edge e) {
    entryMetric=getProxy<MetricProxy>(superGraph,"viewMetric");
    double min,max;
    min=entryMetric->getEdgeMin();
    max=entryMetric->getEdgeMax();

    float h,s,v;
    h=222.0;
    v=80.0/100;

    double dd=entryMetric->getEdgeValue(e)-min;
    s=dd/(max-min);

    float r,g,b;
    HSVtoRGB(&r,&g,&b,h,s,v);
    return Color((int)(r*255.0f),(int)(g*255.0f),(int)(b*255.0f),255);
  }
  bool run() {
#ifndef NDEBUG
    cerr << "LinearMapping::colors" << endl;
#endif
    entryMetric=getProxy<MetricProxy>(superGraph,"viewMetric");

    return true;
  }
  bool check(string &err){
    return true;
  }
};

COLORSPLUGIN(LinearMapping,"Linear","Auber","04/05/2001","0","0","1");





  /*
void GlGraph::buildColor()
{
#ifndef NDEBUG
  cerr << "GlGraph::buildColor()" << endl;
#endif
  nodeColor=getProxy<MetricProxy>(_superGraph,"viewMetric");
  colorMap.clear();
  colorMapMin=0;
  colorMapMax=0;
  bool start=true;
  map<double,int> histo;
  Iterator<node> *itN=_superGraph->getNodes();
  for (;itN->hasNext();) {
    node itn=itN->next();
    double nodeValue=nodeColor->getNodeValue(itn);
    if (start) {
      colorMapMax=nodeValue;
      colorMapMin=nodeValue;
      start=false;
    }
    if (nodeValue>colorMapMax) colorMapMax=nodeValue;
    if (nodeValue<colorMapMin) colorMapMin=nodeValue;
    
    if (histo.find(nodeValue)==histo.end()) {
      histo[nodeValue]=1;
    }
    else
      histo[nodeValue]+=1;
  }delete itN;
  map<double,int>::iterator it;
  double ox=0,oy=0;
  double od=0;
  double tmp=0;
  for (it=histo.begin();it!=histo.end();++it) {
    double x,y;
    x=(*it).first;
    y=(*it).second;
    if (_viewColorEntry==1) {
      od+=sqrt((x-ox)*(x-ox)+(y-oy)*(y-oy));
      ox=x;oy=y;
      colorMap[x]=od;
    }
    else
      if (_viewColorEntry==2) {
	colorMap[x]=tmp;
	tmp++;
      }
  }
  colorMapMin=colorMap[colorMapMin];
  colorMapMax=colorMap[colorMapMax];
}
*/
/*
void GlGraph::buildColor()
{
  colorMap.clear();
  colorMapMin=0;
  colorMapMax=0;
  bool start=true;
  map<double,int> histo;
  Iterator<edge> *itE=_superGraph->getEdges();
  for (;itE->hasNext();)
    {
      edge ite=itE->next();
      double edgeValue=nodeColor->getEdgeValue(ite);
      if (start)
	{
	  colorMapMax=edgeValue;
	  colorMapMin=edgeValue;
	  start=false;
	}
      if (edgeValue>colorMapMax) colorMapMax=edgeValue;
      if (edgeValue<colorMapMin) colorMapMin=edgeValue;

      if (histo.find(edgeValue)==histo.end())
	{
	  histo[edgeValue]=1;
	}
      else
	histo[edgeValue]+=1;
    }
  delete itE;
  map<double,int>::iterator it;

  double ox=0,oy=0;
  double od=0;
  for (it=histo.begin();it!=histo.end();++it)
    {
      double x,y;
      x=(*it).first;
      y=(*it).second;
      od+=sqrt((x-ox)*(x-ox)+(y-oy)*(y-oy));
      //od+=y;
      ox=x;oy=y;
      colorMap[x]=od;
    }
  colorMapMin=colorMap[colorMapMin];
  colorMapMax=colorMap[colorMapMax];
}
*/





