//-*-c++-*-
#include <cmath>

#if (__GNUC__ < 3)
#include <hash_map>
#else
#include <ext/hash_map>
#endif

#include <tulip/TulipPlugin.h>
#include <tulip/Color.h>

using namespace std;
///
inline float MIN(float a,float b) {
  return (a<b ? a : b);
}
inline float MAX(float a,float b) {
  return (a>b ? a : b);
}
void RGBtoHSV( float r, float g, float b, float *h, float *s, float *v )
{
  float min, max, delta;
  min = MIN( MIN( r, g) , b );
  max = MAX( MAX( r, g) , b );
  *v = max;                               // v
  delta = max - min;
  if( max != 0 )
    *s = delta / max;               // s
  else {
    // r = g = b = 0                // s = 0, v is undefined
    *s = 0;
    *h = -1;
    return;
  }
  if( r == max )
    *h = ( g - b ) / delta;         // between yellow & magenta
  else if( g == max )
    *h = 2 + ( b - r ) / delta;     // between cyan & yellow
  else
    *h = 4 + ( r - g ) / delta;     // between magenta & cyan
  *h *= 60;                               // degrees
  if( *h < 0 )
    *h += 360;
}

void HSVtoRGB( float *r, float *g, float *b, float h, float s, float v )
{
        int i;
        float f, p, q, t;
        if( s == 0 ) {
                // achromatic (grey)
                *r = *g = *b = v;
                return;
        }
        h /= 60;                        // sector 0 to 5
        i = (int)floor( h );
        f = h - (float)i;                      // factorial part of h
        p = v * ( 1 - s );
        q = v * ( 1 - s * f );
        t = v * ( 1 - s * ( 1 - f ) );
        switch( i ) {
	case 0:
	  *r = v;
	  *g = t;
	  *b = p;
	  break;
	case 1:
	  *r = q;
	  *g = v;
	  *b = p;
	  break;
	case 2:
	  *r = p;
	  *g = v;
	  *b = t;
	  break;
	case 3:
	  *r = p;
	  *g = q;
	  *b = v;
	  break;
	case 4:
	  *r = t;
	  *g = p;
	  *b = v;
	  break;
	default:                // case 5:
	  *r = v;
	  *g = p;
	  *b = q;
	  break;
        }
}

class UniformQuantificationMapping:public Colors { 
private:
  std::map<double,double> colorMapping;
  std::map<double,double> colorMappingEdge;

public:
  UniformQuantificationMapping(PropertyContext *context):Colors(context){}
  ~UniformQuantificationMapping(){}

  Color getNodeValue(const node n) {
    MetricProxy *entryMetric=getProxy<MetricProxy>(superGraph,"viewMetric");
    float h,s,v;
    s=1;
    v=1;
    float r,g,b;
    h=60+colorMapping[entryMetric->getNodeValue(n)];
    HSVtoRGB(&r,&g,&b,h,s,v);
    return Color((int)(r*255.0f),(int)(g*255.0f),(int)(b*255.0f),255);
  }

  Color getEdgeValue(const edge e) {
    MetricProxy *entryMetric=getProxy<MetricProxy>(superGraph,"viewMetric");
    float h,s,v;
    h=218;
    s=1;
    v=0.66;
    float r,g,b;
    s=colorMappingEdge[entryMetric->getEdgeValue(e)]/300;
    HSVtoRGB(&r,&g,&b,h,s,v);
    return Color((int)(r*255.0f),(int)(g*255.0f),(int)(b*255.0f),255);
  }


  bool run() {
#ifndef NDEBUG
    cerr << "UniformQuantificationMapping::colors" << endl;
#endif
    MetricProxy *entryMetric=getProxy<MetricProxy>(superGraph,"viewMetric");
    colorMapping.clear();
    bool start=true;
    //===============================================================
    //build the histogram of node values
    {
      map<double,int> histogram;
      Iterator<node> *itN=superGraph->getNodes();
      for (;itN->hasNext();) {
	node itn=itN->next();
	double nodeValue=entryMetric->getNodeValue(itn);
	if (histogram.find(nodeValue)==histogram.end()) {
	  histogram[nodeValue]=1;
	}
	else
	  histogram[nodeValue]+=1;
      }delete itN;
      //===============================================================
      //Build the color map
      map<double,int>::iterator it;
      double sum=0;
      double cK=superGraph->numberOfNodes()/300;
      int k=0;
      for (it=histogram.begin();it!=histogram.end();++it) {
	double x,y;
	x=(*it).first;
	sum+=(*it).second;
	colorMapping[x]=k;
	while (sum>cK*(k+1)) ++k;
      }
    }
    
    //===============================================================
    //build the histogram of edges values
    {
      map<double,int> histogram;
      Iterator<edge> *itE=superGraph->getEdges();
      for (;itE->hasNext();) {
	edge ite=itE->next();
	double value=entryMetric->getEdgeValue(ite);
	if (histogram.find(value)==histogram.end()) {
	  histogram[value]=1;
	}
	else
	  histogram[value]+=1;
      }delete itE;
      //===============================================================
      //Build the color map
      map<double,int>::iterator it;
      double sum=0;
      double cK=(double)superGraph->numberOfEdges()/300;
      int k=0;
      for (it=histogram.begin();it!=histogram.end();++it) {
	double x,y;
	x=(*it).first;
	sum+=(*it).second;
	colorMappingEdge[x]=k;
	while (sum>cK*(k+1)) ++k;
      }
    }
    //===============================================================
    return true;
  }
  bool check(string &err){
    return true;
  }
};
COLORSPLUGIN(UniformQuantificationMapping,"UniformQuantification","Auber","04/05/2001","0","0","1");
