#include <GL/gl.h>
#include <GL/glu.h>

#include <tulip/StringProxy.h>
#include <tulip/ColorsProxy.h>

#include <tulip/SuperGraph.h>
#include <tulip/Glyph.h>

#include <iostream>
using namespace std;

class Sphere : public Glyph {
public:
  Sphere(GlyphContext *gc=NULL);
  virtual ~Sphere();
  virtual string getName() {return string("Sphere");}
  virtual void draw(node n);
  virtual void setLOD(int n);

private:
  GLuint LList;
  bool listOk;
};

GLYPHPLUGIN(Sphere, "Sphere", "Bertrand Mathieu", "09/07/2002", "Textured sphere", "1", "1");

//=========================================================================================
Sphere::Sphere(GlyphContext *gc): Glyph(gc),listOk(false) {
  setLOD(8);
}

Sphere::~Sphere(){
  if (listOk) glDeleteLists(LList, 1);
}

void Sphere::setLOD(int n) {
  LOD = ((n<0) ? 0 : ((n > 10) ? 10 : n));
  if (listOk) {glDeleteLists(LList, 1);listOk=false;};
}

void Sphere::draw(node n) {
  this->setMaterial(glGraph->elementColor->getNodeValue(n));
  string texFile = glGraph->elementTexture->getNodeValue(n);
  if (texFile != "") {
    if (glGraph->activateTexture(texFile))
      setMaterial(Color(255,255,255,255));
  }
  if (!listOk) {
    GLUquadricObj *quadratic;
    quadratic = gluNewQuadric();
    gluQuadricNormals(quadratic, GLU_SMOOTH);
    gluQuadricTexture(quadratic, GL_TRUE);  
    LList = glGenLists( 1 );
    glNewList( LList, GL_COMPILE ); 
    gluSphere(quadratic, 0.5f, LOD, LOD);
    glEndList();
    gluDeleteQuadric(quadratic);
    listOk=true;
  }
  glCallList(LList);
}

