#include <sys/timeb.h>
#include<qinputdialog.h>
#include <tulip/TulipPlugin.h>

using namespace std;

struct CompleteGraph:public ImportModule
{
  CompleteGraph(ClusterContext context):ImportModule(context){}
  ~CompleteGraph(){}
  
  bool import(const string &name) {
    bool ok;
    int nbNodes = QInputDialog::getInteger( QString("Please enter the number of nodes of the graph "),QString("Number of nodes"), 0, 0, 1000000, 10, &ok );
    if (!ok) return false;
    for (int j=0;j<nbNodes;j++) superGraph->addNode();
    Iterator<node> *it1,*it2;
    it1=superGraph->getNodes();
    int i=0;
    for (;it1->hasNext();) {
      if (!pluginProgress->progress(i,nbNodes)) return false;
      i++;
      node n1=it1->next();
      it2=superGraph->getNodes();
      for (;it2->hasNext();) {
	node n2=it2->next();
	if (n1!=n2) superGraph->addEdge(n1,n2);
      }
      delete it2;
    }
    delete it1;
    return true;
  }
};
IMPORTPLUGIN(CompleteGraph,"Complete General Graph","Auber","16/12/2002","0","0","1")
