/****************************************************************/
/*								*/
/*		PosetImport.cpp		                	*/
/*	Reads in the poset  given by the matrices.		*/
/*	Expected input is <Input>=<Size> <Matrix1> <Matrix> ...	*/
/*	Where <Size> is a positive number, 			*/
/*	and <Matrixn> is a <size>x<size> 0-1 matrix.		*/
/*	The delimeters between the numbers can be any white	*/
/*	space. Any remaining data in the file is ignored.	*/
/*	If there is no enough tokens to generate the graph	*/
/*	an exception is generated.				*/
/*								*/
/*	Written by Luis Garcia & Davud Auber.			*/
/*	October, 2001		            			*/
/*								*/
/****************************************************************/

#include <fstream>
#include <math.h>
#include <tulip/TulipPlugin.h>

using namespace std;

struct PosetImport:public ImportModule
{
  PosetImport(ClusterContext context):ImportModule(context){
    addParameter<string>("filename");
  }
  ~PosetImport(){}

  bool import(const string &name)
  {
    std::ifstream in(name.c_str());
    unsigned int size=0;
    char v;
    int layerDraw=0;
    LayoutProxy *posetLayout=getProxy<LayoutProxy>(superGraph,"viewLayout");
    getProxy<SizesProxy>(superGraph,"viewSize")->setAllNodeValue(Size(1,1,1));


    in>>size;
    //some error checking
    if (size==0)
      {
	std::cerr<<"****\n**** File "<<name
		 <<":\n**** size of the graph cannot be zero.\n"
		 <<"****\n";
	return false;
      }
   
    //create nodes
    vector<node> layer1, layer2, *layerup, *layerdown;
    for (unsigned int i=0;i<size;++i)
      {
	layer1.push_back(superGraph->addNode());
	posetLayout->setNodeValue(layer1[i],Coord(size*2-i*2,layerDraw,0));
				  
	layer2.push_back(superGraph->addNode());
	posetLayout->setNodeValue(layer2[i],Coord(size*2-i*2,layerDraw+1,0));
      }
    layerDraw++;

    // StringProxy *labels=getLocalProxy<StringProxy>(superGraph->getPropertyProxyContainer(),"viewLabel");

    //create edges
    layerup = &layer1;
    layerdown =&layer2;
    do
      {
	for (unsigned int i=0;i<size;i++)
	  {
	    for (unsigned int j=0;j<size;j++)
	      {
		in>>v;
		if (v=='1') 
		  superGraph->addEdge((*layerup)[i],(*layerdown)[j]);
	      }
	  }
	in>>v;
	if(v=='+')
	  {
	    //Build a new layer
	    {
	      layerup->clear();
	      for (unsigned int i=0;i<size;++i) 
		{
		  layerup->push_back(superGraph->addNode());
		  posetLayout->setNodeValue((*layerup)[i],Coord(size*2-i*2,layerDraw+1,0));
		}
	      layerDraw++;
	    }
	    //Swap the two layers
	    {
	      vector<node> *tmp=layerup;
	      layerup=layerdown;
	      layerdown=tmp;
	    }
	  }
      }while (v=='+');

    return true;    
  }

};

IMPORTPLUGIN(PosetImport,"Poset Import","Luis & David", "10/31/2001","0","0","1")

