#include <sys/timeb.h>
#include<qinputdialog.h>
#include <tulip/TulipPlugin.h>

using namespace std;

struct RandomTree:public ImportModule
{
  RandomTree(ClusterContext context):ImportModule(context)
  {}
  ~RandomTree(){}
  bool buildNode(node n,int sizeM)
  {
    if (superGraph->numberOfNodes()>sizeM+2) return false;
    bool result=true;
    int randNumber=rand();
    if (randNumber>RAND_MAX/2)
      {
	node n1,n2;
	n1=superGraph->addNode();
	n2=superGraph->addNode();
	superGraph->addEdge(n,n1);
	superGraph->addEdge(n,n2);
	result= result && buildNode(n1,sizeM);
	result= result && buildNode(n2,sizeM);
      }
    return result;
  }
  bool import(const string &name)
  {
    timeb tmp;
    ftime(&tmp);
    srand(tmp.time); 
    bool ok=true;

    int resMin = QInputDialog::getInteger( QString("Please enter the minimum size of the tree"),QString("Min Tree Size"), 0, 0, 1000000, 10, &ok );
    if (!ok) return false;
    int resMax = QInputDialog::getInteger( QString("Please enter the maximum size of the tree"),QString("Max Tree Size"), resMin, resMin, 1000000, 10, &ok );
    if (!ok) return false;
    int i=0;
    while (ok) {
      if (!pluginProgress->progress(i%100,100)) return false;
      i++;
      Iterator<node> *it=superGraph->getNodes();
      while(it->hasNext()) superGraph->delNode(it->next());
      delete it;
	
      node n=superGraph->addNode();
      ok=!buildNode(n,resMax);
      if (superGraph->numberOfNodes()<resMin-2) ok=true;
    }
    return true;
  }
};
IMPORTPLUGIN(RandomTree,"Uniform Random Binary Tree","Auber","16/02/2001","0","0","1")
