#include <sys/timeb.h>
#include<qinputdialog.h>
#include <tulip/TulipPlugin.h>

using namespace std;

struct SmallWorldGraph:public ImportModule
{
  SmallWorldGraph(ClusterContext context):ImportModule(context)
  {}
  ~SmallWorldGraph(){}
  
  bool import(const string &name) {
    timeb tmp;
    ftime(&tmp);
    srand(tmp.time); 
    bool ok=true;
    
    int nbNodes = QInputDialog::getInteger( QString("Please enter the number of nodes"), QString("Number of nodes"), 0 , 0, 1000000,1, &ok );
    if (!ok) return false;
    int maxDistance = QInputDialog::getInteger( QString("Please enter the maximum distance between two linked nodes"),QString("Maximaal distance"), 0, 0, 1000000, 1, &ok );
        if (!ok) return false;
    if (!ok) return false;

    LayoutProxy *newLayout=getLocalProxy<LayoutProxy>(superGraph,"viewLayout");
    vector<node> graph(nbNodes);
    for (int i=0; i<nbNodes;++i) {
      graph[i]=superGraph->addNode();
      newLayout->setNodeValue(graph[i],Coord(rand()%1024,rand()%1024,0));
    }
    
    for (int i=0;i<nbNodes-1;++i) 
      for (int j=i+1;j<nbNodes;++j) {
	if (i!=j) {
	  if (newLayout->getNodeValue(graph[i]).dist(newLayout->getNodeValue(graph[j]))<(double)maxDistance) superGraph->addEdge(graph[i],graph[j]);
	}
      }
    return true;
  }
};
IMPORTPLUGIN(SmallWorldGraph,"Small World Graph","Auber","25/06/2002","0","0","1")
