#include <cassert>
#include <stdio.h>

#include "Barycenter.h"

METRICPLUGIN(BarycenterMetric,"Barycenter","David Auber","10/03/2000","Alpha","0","1");

using namespace std;

BarycenterMetric::BarycenterMetric(PropertyContext *context):Metric(context) {}

BarycenterMetric::~BarycenterMetric() {}

class LessThanNode2
{
public:
  MetricProxy *metric;
  bool operator() (node n1,node n2){return (metric->getNodeValue(n1) < metric->getNodeValue(n2));}
};
//======================================================
bool BarycenterMetric::run() {
  list<node> tmpFifo;
  map<unsigned int,list<node> > grid;
  STL_EXT_NS::hash_map<node,bool> visited;

  bool cached,resultBool;
  string erreurMsg;
  Iterator<node> *itN=superGraph->getNodes();
  MetricProxy *dagLevel = getLocalProxy<MetricProxy>(superGraph,"DagLevel",cached,resultBool,erreurMsg);
  
  for(;itN->hasNext();){
    node itn=itN->next();
    int level=(int)dagLevel->getNodeValue(itn);
    metricProxy->setNodeValue(itn,grid[level].size());
    grid[level].push_back(itn);
  } delete itN;

  unsigned int maxDepth=grid.rbegin()->first;

  LessThanNode2 lessNode;
  lessNode.metric=metricProxy;

  for (int a=0;a<4;++a) {

    for (unsigned int i=1;i<=maxDepth;++i) {
      list<node>::iterator it;
      for (it=grid[i].begin();it!=grid[i].end();++it) {
	node n=*it;
	if (superGraph->indeg(n)>0) {
	  double sum=0;
	  Iterator<node>*itN=superGraph->getInNodes(n);
	  for(;itN->hasNext();)   {
	    node itn=itN->next();
	    sum+=metricProxy->getNodeValue(itn);
	  }delete itN;
	  metricProxy->setNodeValue(n,sum/superGraph->indeg(n));
	}
      }
      grid[i].sort(lessNode);
      unsigned int j=0;
      it=grid[i].begin();
      for (;it!=grid[i].end();++it) {
	metricProxy->setNodeValue(*it,j);
	j++;
      }
    }
    
    for (int i=maxDepth-1;i>=0;--i) {
      list<node>::iterator it;
      for (it=grid[i].begin();it!=grid[i].end();++it) {
	node n=*it;
	if (superGraph->outdeg(n)>0){
	  double sum=0;
	  Iterator<node>*itN=superGraph->getOutNodes(n);
	  for(;itN->hasNext();)   {
	    node itn=itN->next();
	    sum+=metricProxy->getNodeValue(itn);
	  }delete itN;
	  metricProxy->setNodeValue(n,sum/superGraph->outdeg(n));
	}
      }
    
      grid[i].sort(lessNode);
      unsigned int j=0;
      it=grid[i].begin();
      for (;it!=grid[i].end();++it) {
	metricProxy->setNodeValue(*it,j);
	j++;
      }
    }
  } 
  return true;
}

bool BarycenterMetric::check(string &erreurMsg)
{
  if (superGraph->isAcyclic()) {
    erreurMsg="";
    return true;
  }
  else {
    erreurMsg="The Graph must be a acylic";
    return false;
  }
}
