#if (__GNUC__ < 3)
#include <hash_map>
#else
#include <ext/hash_map>
#endif

#include "ConnectedComponent.h"


METRICPLUGIN(ConnectedComponent,"Connected Component","David Auber","01/07/2002","Alpha","0","1");

ConnectedComponent::ConnectedComponent(PropertyContext *context):Metric(context) {}

ConnectedComponent::~ConnectedComponent(){}

void ConnectedComponent::dfs(node n, STL_EXT_NS::hash_map<node,bool> &flag,double value){
  if (flag.find(n)!=flag.end()) return;
  flag[n]=true;
  metricProxy->setNodeValue(n,value);
  Iterator<node> *itN=superGraph->getInOutNodes(n);
  for (;itN->hasNext();) {
    node itn=itN->next();
    dfs(itn,flag,value);
  }delete itN;
}


bool ConnectedComponent::run()
{
  STL_EXT_NS::hash_map<node,bool> flag;

  double curComponent=0;
  Iterator<node> *itN=superGraph->getNodes();
  for (;itN->hasNext();) {
    node itn=itN->next();
    if (flag.find(itn)==flag.end()) {
      dfs(itn,flag,curComponent);
      curComponent++;
    }
  }delete itN;

  return true;
}








