#include <cassert>

#include "DagLevelMetric.h"

METRICPLUGIN(DagLevelMetric,"DagLevel","David Auber","10/03/2000","Alpha","0","1");

using namespace std;

DagLevelMetric::DagLevelMetric(PropertyContext *context):Metric(context) 
{}

DagLevelMetric::~DagLevelMetric() {}
//======================================================
bool DagLevelMetric::run()
{
  list<node> tmpFifo;
  list<node> reverseBfsNodeTraversal;
  node tmpNode;
  Iterator<node> *itN;
  //===============================================
  //insertion des sources du Dag dans la fifo
  itN=superGraph->getNodes();
  for(;itN->hasNext();)
    {
      node itn=itN->next();
      if (superGraph->indeg(itn)==0)
	  tmpFifo.push_back(itn);
    }
  delete itN;

  //==============================================
  //Dbut du Bfs de Dags
  while (!tmpFifo.empty())
    {
      tmpNode=*(tmpFifo.begin());
      tmpFifo.pop_front();
      reverseBfsNodeTraversal.push_front(tmpNode);
      itN=superGraph->getOutNodes(tmpNode);
      for(;itN->hasNext();)
	{
	  node itChildNode=itN->next();
	  if (metricProxy->getNodeValue(itChildNode)<metricProxy->getNodeValue(tmpNode)+1)
	    {
	      metricProxy->setNodeValue(itChildNode,metricProxy->getNodeValue(tmpNode)+1);
	      tmpFifo.push_back(itChildNode);
	    }
	}
      delete itN;
    }

  double tmpMin;
  list<node>::iterator itNode;
  for (itNode=reverseBfsNodeTraversal.begin();itNode!=reverseBfsNodeTraversal.end();++itNode)
    {
      itN=superGraph->getOutNodes(*itNode);
      if(itN->hasNext())
	{
	  node itChildNode=itN->next();
	  tmpMin=metricProxy->getNodeValue(itChildNode);
	  for (;itN->hasNext();)
	    {
	      itChildNode=itN->next();
	      if (tmpMin>metricProxy->getNodeValue(itChildNode))
		tmpMin=metricProxy->getNodeValue(itChildNode);
	    }
	  metricProxy->setNodeValue(*itNode,tmpMin-1);
	}
      delete itN;
    }
  reverseBfsNodeTraversal.clear();
  return true;
}

bool DagLevelMetric::check(string &erreurMsg)
{
  if (superGraph->isAcyclic())
    {
      erreurMsg="";
      return true;
    }
  else
    {
      erreurMsg="The Graph must be a acylic";
      return false;
    }
}















