//-*-c++-*-
/**
 Author: David Auber
 Email : auber@labri.fr
 Last modification : 20/08/2001
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#include <assert.h>
#include <qinputdialog.h>
#include "ReachableSubGraphSelection.h"
#include <tulip/SelectionProxy.h>
#include <tulip/MethodFactory.h>

SELECTIONPLUGIN(ReachableSubGraphSelection,"ReachableSubGraph","David Auber","01/12/1999","Alpha","0","1");

ReachableSubGraphSelection::ReachableSubGraphSelection(PropertyContext *context):Selection(context) 
{}

ReachableSubGraphSelection::~ReachableSubGraphSelection() {}

void ReachableSubGraphSelection::walkInGraph(node n,SelectionProxy *flag,int depth,int curDepth)
{
  selectionProxy->setNodeValue(n,true);
  flag->setNodeValue(n,true);

  Iterator<edge> *itE=superGraph->getOutEdges(n);
  for (;itE->hasNext();) {
    edge it=itE->next();
    if (curDepth>=depth) {
      if (flag->getNodeValue(superGraph->target(it))) {
	selectionProxy->setEdgeValue(it,true);
      }
    }
    else {
      selectionProxy->setEdgeValue(it,true);
      if (!flag->getNodeValue(superGraph->target(it))) {
	walkInGraph(superGraph->target(it),flag,depth,curDepth+1);
      }
    }
  }delete itE;

  itE=superGraph->getInEdges(n);
  for (;itE->hasNext();) {
    edge it=itE->next();
    if (flag->getNodeValue(superGraph->source(it))) {
      selectionProxy->setEdgeValue(it,true);
    }
  }delete itE;
}

///===========================================================
///Calcul l'arbre couvrant
bool ReachableSubGraphSelection::run()
{
  //  cerr << "Enter in ReachableSubGraph Selection" << endl;
  Iterator<node> *itN;
  bool ok=true;
  int maxDepth = QInputDialog::getInteger(QString("Please enter depth "),
					  QString("depth"), 0, 0, 1000000, 10, &ok );

  SelectionProxy *nodeFlag=getLocalProxy<SelectionProxy>(superGraph,"flagSelection");
  selectionProxy->setAllEdgeValue(false);
  selectionProxy->setAllNodeValue(false);
  PropertyProxyContainer *graphProperties=superGraph->getPropertyProxyContainer();
  if (graphProperties->existProxy("viewSelection")) {
    itN=superGraph->getNodes();
    for (;itN->hasNext();) { 
      node n=itN->next();
      if ((getProxy<SelectionProxy>(superGraph,"viewSelection")->getNodeValue(n))) {
	walkInGraph(n,nodeFlag,maxDepth,0);
      }
    } delete itN;
  }
  graphProperties->delLocalProxy("flagSelection");
  return true;
}




