#include <cassert>

#include <tulip/SelectionProxy.h>
#include <tulip/MethodFactory.h>

#include "SpanningDagSelection.h"

SELECTIONPLUGIN(SpanningDagSelection,"SpanningDag","David Auber","01/12/1999","Alpha","0","1");

using namespace std;

SpanningDagSelection::SpanningDagSelection(PropertyContext *context):Selection(context) {}

SpanningDagSelection::~SpanningDagSelection() {}

void  SpanningDagSelection::dfsAcyclicTest(const node &n,SelectionProxy *visited,SelectionProxy *finished)
{
  visited->setNodeValue(n,true);
  Iterator<edge> *it=superGraph->getOutEdges(n);
  for (;it->hasNext();)
    {
      edge tmp=it->next();
      if ((visited->getNodeValue(superGraph->target(tmp)))==true)
	{
	  if ((finished->getNodeValue(superGraph->target(tmp)))==true) 
	    selectionProxy->setEdgeValue(tmp,true);
	}
      else
	{
	  selectionProxy->setEdgeValue(tmp,true);
	  dfsAcyclicTest(superGraph->target(tmp),visited,finished);
	}
    }
  delete it;
  finished->setNodeValue(n,true);
}

bool SpanningDagSelection::run()
{
  PropertyProxyContainer *pPC=superGraph->getPropertyProxyContainer();
  SelectionProxy *visited=getLocalProxy<SelectionProxy>(superGraph,"SpanningDagSelectionAcyclicTestVisited");
  SelectionProxy *finished=getLocalProxy<SelectionProxy>(superGraph,"SpanningDagSelectionAcyclicTestFinished");
  SelectionProxy *parameter=getProxy<SelectionProxy>(superGraph,"viewSelection");

  visited->setAllNodeValue(false);
  finished->setAllNodeValue(false);

  Iterator<node> *it=superGraph->getNodes();
  for (;it->hasNext();)
    {
      node curNode=it->next();
      if ((!visited->getNodeValue(curNode)) && (parameter->getNodeValue(curNode)) )
	{
	  dfsAcyclicTest(curNode,visited,finished);
	}
    }
  delete it;

  //On regarde pour les sommets restant non trait par la selection passe en pamatre
  it=superGraph->getNodes();
  for (;it->hasNext();)
    {
      node curNode=it->next();
      if (!visited->getNodeValue(curNode))
	{
	  dfsAcyclicTest(curNode,visited,finished);
	}
    }
  delete it;
  
  selectionProxy->setAllNodeValue(true);
  pPC->delLocalProxy("SpanningDagSelectionAcyclicTestVisited");
  pPC->delLocalProxy("SpanningDagSelectionAcyclicTestFinished");
  return true;
}

bool SpanningDagSelection::check(string &erreurMsg)
{
  erreurMsg="";
  return (true);
}

void SpanningDagSelection::reset()
{}

