#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <qprogressbar.h>
#include <qlabel.h>

#include "AppStartUp.h"

using namespace std;
/* 
 *  Constructs a AppStartUp which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
AppStartUp::AppStartUp( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : AppStartUpForm( parent, name, modal, fl )
{
}

/*  
 *  Destroys the object and frees any allocated resources
 */
AppStartUp::~AppStartUp()
{
    // no need to delete child widgets, Qt does it all for us
}

void AppStartUp::setProgress(int progress)
{
  progressBar->setProgress(progress);
}
 
void AppStartUp::setTotalSteps(int totalSteps)
{
  progressBar->setTotalSteps(totalSteps);
}
 
void AppStartUp::setLabel(string str)
{
  QString tmpQString=str.c_str();
  textLabel->setText(tmpQString);
}
