#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tulip/SuperGraph.h>
#include <tulip/PropertyProxyContainer.h>
#include <tulip/SelectionProxy.h>
#include <tulip/LayoutProxy.h>
#include <tulip/GlGraphWidget.h>

#include "MouseSelection.h"

using namespace std;
using namespace Tulip;

MouseSelection::MouseSelection():
  x(0),y(0),w(0),h(0),started(false),superGraph(0)
{}

void MouseSelection::mPressEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){
  if (qMouseEv->button()==QEvent::LeftButton) {
    if (!started) {
      x=qMouseEv->x();
      y=glGraphWidget->height() - qMouseEv->y();
      w=0;h=0;
      started=true;
      glGraphWidget->setMouseTracking(true);
      superGraph=glGraphWidget->getGlGraph()->getSuperGraph();
    }
    else {
      if (glGraphWidget->getGlGraph()->getSuperGraph()!=superGraph) {
	superGraph=0;started=false;glGraphWidget->setMouseTracking(false);
      }
    }
  }

  if (qMouseEv->button()==QEvent::MidButton){
    started=false;glGraphWidget->setMouseTracking(false);
    glGraphWidget->redraw();
  }
  if (qMouseEv->button()==QEvent::RightButton) {}
}

void MouseSelection::mPaint(GlGraphWidget *glGraphWidget){
  if (glGraphWidget->getGlGraph()->getSuperGraph()!=superGraph) {
    superGraph=0;started=false;glGraphWidget->setMouseTracking(false);
  }
  if (!started) return;
  glMatrixMode (GL_PROJECTION);
  glPushMatrix();
  glLoadIdentity ();
  gluOrtho2D (0.0, (GLdouble) glGraphWidget->width(), 0.0, (GLdouble) glGraphWidget->height());
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glLoadIdentity();
  glDisable(GL_LIGHTING);
  glDisable(GL_CULL_FACE);
  glDisable(GL_DEPTH_TEST);
  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA,GL_SRC_COLOR);
  float col[4]={0.8,0.8,0.7,0.2};
  glColor4fv(col);
  glBegin(GL_QUADS);
  glVertex2f(x,y);
  glVertex2f(x+w,y);
  glVertex2f(x+w,y-h);
  glVertex2f(x,y-h);
  glEnd();
  glDisable(GL_BLEND);
  glLineWidth(2);
  glLineStipple(2, 0xAAAA);
  glEnable(GL_LINE_STIPPLE);
  glBegin(GL_LINE_LOOP);
  glVertex2f(x,y);
  glVertex2f(x+w,y);
  glVertex2f(x+w,y-h);
  glVertex2f(x,y-h);
  glEnd();
  glLineWidth(1);
  glDisable(GL_LINE_STIPPLE);
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_CULL_FACE);
  glEnable(GL_LIGHTING);
  glPopMatrix();
  glMatrixMode (GL_PROJECTION);
  glPopMatrix();
  glMatrixMode (GL_MODELVIEW);
}
/*

*/
void MouseSelection:: mReleaseEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){
  if (glGraphWidget->getGlGraph()->getSuperGraph()!=superGraph) {
    superGraph=0;started=false;glGraphWidget->setMouseTracking(false);
  }
  if (started) {
    glGraphWidget->setMouseTracking(false);
    Observable::holdObservers();
    SelectionProxy*selection=getProxy<SelectionProxy>(glGraphWidget->getGlGraph()->getSuperGraph(),"viewSelection");
    if (qMouseEv->state()!=QEvent::ControlButton) {
      selection->setAllNodeValue(false);
      selection->setAllEdgeValue(false);
    }
    if ((w==0) && (h==0)) {
      node tmpNode;
      edge tmpEdge;
      AtomType type;
      bool result=glGraphWidget->getGlGraph()->doSelect(x, y, type, tmpNode, tmpEdge);
      if (result){
        switch(type) {
        case NODE: selection->setNodeValue(tmpNode,true); break;
        case EDGE: selection->setEdgeValue(tmpEdge,true); break;
        }
      }
    }
    set<node> tmpSetNode;
    set<edge> tmpSetEdge;
    int centX= (x+x+w)/2;
    int centY= (y+y-h)/2;
    if (w<0) w*=-1;
    if (h<0) h*=-1;
    glGraphWidget->getGlGraph()->doSelect(centX,centY,w,h,tmpSetNode,tmpSetEdge);
    set<node>::const_iterator it;
    for (it=tmpSetNode.begin();it!=tmpSetNode.end();++it) {
      selection->setNodeValue(*it,true);
    }
    set<edge>::const_iterator ite;
    for (ite=tmpSetEdge.begin();ite!=tmpSetEdge.end();++ite) {
      selection->setEdgeValue(*ite,true);
    }
    started=false;
    glGraphWidget->redraw();
    Observable::unholdObservers();
  }
}
void MouseSelection:: mMoveEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv)
{
  if (glGraphWidget->getGlGraph()->getSuperGraph()!=superGraph) {
    superGraph=0;started=false;glGraphWidget->setMouseTracking(false);
  }
  if (started){
    if ((qMouseEv->x()>0) && (qMouseEv->x()<glGraphWidget->width()))
      w = qMouseEv->x() - x ;
    if ((qMouseEv->y()>0) && (qMouseEv->y()<glGraphWidget->height()))
      h = y - (glGraphWidget->height() - qMouseEv->y());
    glGraphWidget->redraw();
  }
}
