#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qcolor.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qcolordialog.h>
#include <Application.h>
#include <tulip/GlGraph.h>

#include "View3DSetup.h"

using namespace std;
/* 
 *  Constructs a View3DSetup which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
View3DSetup::View3DSetup( GlGraph *glWidget, QWidget* parent,  const char* name, bool modal, WFlags fl )
  : View3DSetupData( parent, name, modal ) {
  tmpColorBack.setRgb(65,65,65);
  tmpColorNode.setRgb(255,0,0);
  tmpColorEdge.setRgb(0,85,255);
  tmpStrahler=false;
  tmpKey=false;
  tmpLabel=false;
  tmpArrow=false;
  tmpColorMapping="Linear";
  tmpAutoMapMetric=true;
  tmpOrthogonal=true;
  tmpAutoScale=true;
  tmpEdgeColorInterpolation=true;
  tmp3DEdges=false;
  backColorButton->setBackgroundMode( QWidget::PaletteBase );
  colorNodeButton->setBackgroundMode( QWidget::PaletteBase );
  colorEdgeButton->setBackgroundMode( QWidget::PaletteBase );
  backColorButton->setPalette(QPalette(tmpColorBack));
  colorNodeButton->setPalette(QPalette(tmpColorNode));
  colorEdgeButton->setPalette(QPalette(tmpColorEdge));
  checkAutoScale->setChecked(true);
  checkOrthogonal->setChecked(true);
  checkAutoMap->setChecked(true);
  this->glWidget=glWidget;
  ((Application *)qApp)->nodeColor=Color(tmpColorNode.red(),tmpColorNode.green(),tmpColorNode.blue());
  ((Application *)qApp)->edgeColor=Color(tmpColorEdge.red(),tmpColorEdge.green(),tmpColorEdge.blue());
}

View3DSetup::~View3DSetup() {}

void View3DSetup::cancelButtonPress() {}

void View3DSetup::syncFromGlGraph() {
  tmpStrahler = glWidget->isViewStrahler();
  checkStrahler->setChecked(tmpStrahler);
  tmpLabel = glWidget->isViewLabel();
  tmpFont = glWidget->fontsType();
  QString fontStyleName;
  if (tmpLabel && (tmpFont==0)) fontStyleName="3D";
  else if (tmpLabel && (tmpFont==1)) fontStyleName="Bitmap";
  else if (tmpLabel && (tmpFont==2)) fontStyleName="Texture";
  else fontStyleName="None";
  int i;
  for (i=0; (i<comboLabelInput->count()) && ((comboLabelInput->text(i)) != fontStyleName); ++i);
  comboLabelInput->setCurrentItem(i);
  
  tmpArrow = glWidget->isViewArrow();
  checkArrows->setChecked(tmpArrow);
  tmpEdgeColorInterpolation = glWidget->isEdgeColorInterpolate();
  checkEdgeInterpolation->setChecked(tmpEdgeColorInterpolation);
  tmp3DEdges = glWidget->isEdged3D();
  check3DEdges->setChecked(tmp3DEdges);
  
  Color c = glWidget->getBackgroundColor();
  tmpColorBack.setRgb(c.getR(), c.getG(), c.getB());
  backColorButton->setPalette(QPalette(tmpColorBack));

  /*
    c = glWidget->getNodeBaseColor();
    tmpColorNode.setRgb(c.getR(), c.getG(), c.getB());
    colorNodeButton->setPalette(QPalette(tmpColorNode));
    c = glWidget->getEdgeBaseColor();
    tmpColorEdge.setRgb(c.getR(), c.getG(), c.getB());
    colorEdgeButton->setPalette(QPalette(tmpColorEdge));
  */

  tmpKey = glWidget->isViewKey();
  checkKey->setChecked(tmpKey);
  tmpOrthogonal = glWidget->isViewOrtho();
  checkOrthogonal->setChecked(tmpOrthogonal);
  //  tmpAutoScale = glWidget->isViewAutoScale();
  checkAutoScale->setChecked(tmpAutoScale);
}

void View3DSetup::backColor() {
  QColor tmp=QColorDialog::getColor(tmpColorBack, this,"Tulip background color" ) ;
  if (tmp.isValid()) tmpColorBack=tmp;
  backColorButton->setPalette(QPalette(tmpColorBack));
}

void View3DSetup::colorNode() {
  QColor tmp=QColorDialog::getColor(tmpColorNode, this,"Tulip node color" ) ;
  if (tmp.isValid()) tmpColorNode=tmp;
  colorNodeButton->setPalette(QPalette(tmpColorNode));
}

void View3DSetup::colorEdge() {
  QColor tmp=QColorDialog::getColor(tmpColorEdge, this,"Tulip edge color" ) ;
  if (tmp.isValid()) tmpColorEdge=tmp;
  colorEdgeButton->setPalette(QPalette(tmpColorEdge));
}

void View3DSetup::applyButtonPress() {
  bool scale=false;
  glWidget->setViewStrahler(tmpStrahler);
  glWidget->setViewLabel(tmpLabel);
  glWidget->setFontsType(tmpFont);
  glWidget->setViewArrow(tmpArrow);
  glWidget->setEdgeColorInterpolate(tmpEdgeColorInterpolation);
  glWidget->setEdge3D(tmp3DEdges);
  ((Application *)qApp)->nodeColor=Color(tmpColorNode.red(),tmpColorNode.green(),tmpColorNode.blue());
  ((Application *)qApp)->edgeColor=Color(tmpColorEdge.red(),tmpColorEdge.green(),tmpColorEdge.blue());
  glWidget->setBackgroundColor(tmpColorBack.red(),tmpColorBack.green(),tmpColorBack.blue());
  glWidget->setViewKey(tmpKey);
  if (glWidget->isViewOrtho()!=tmpOrthogonal) {
    glWidget->setViewOrtho(tmpOrthogonal);
    scale=true;
  }
  if (glWidget->isViewStrahler()!=tmpStrahler) {
    glWidget->setViewStrahler(tmpStrahler);
  }
  if (scale) glWidget->goodScale();
  glWidget->redraw();
}

void View3DSetup::okButtonPress() {
  this->hide();
  applyButtonPress();
}


void View3DSetup::setLabels(const QString &str) {
  if (str=="None") tmpLabel=false;
  if (str=="3D") { tmpLabel=true; tmpFont=0;}
  if (str=="Bitmap") { tmpLabel=true; tmpFont=1;}
  if (str=="Texture") { tmpLabel=true; tmpFont=2;}
}


//GlGraph Parameter
void View3DSetup::setStrahler(bool b){tmpStrahler=b;}
void View3DSetup::setOrthogonal(bool b){tmpOrthogonal=b;}
void View3DSetup::setViewArrow(bool b){tmpArrow= b;}
void View3DSetup::setViewKey(bool b){tmpKey=b;}
void View3DSetup::setViewLabel(bool b){tmpLabel=b;}
void View3DSetup::setEdgeColorInterpolation(bool b){tmpEdgeColorInterpolation=b;}
void View3DSetup::set3DEdges(bool b) {tmp3DEdges=b;}


//ViewGl Parameter

void View3DSetup::setAutoMapMetric(bool b){tmpAutoMapMetric=b;}
void View3DSetup::setAutoScale(bool b){cerr << __PRETTY_FUNCTION__ << ":" << b <<endl; tmpAutoScale=b;}
string View3DSetup::getColorMapping() {return tmpColorMapping;}
bool View3DSetup::isAutoMapMetric() {return tmpAutoMapMetric;}
bool View3DSetup::isAutoScale() {cerr << __PRETTY_FUNCTION__ << ":" << tmpAutoScale <<endl; return tmpAutoScale;}
Color  View3DSetup::getNodeColor(){return Color(tmpColorNode.red(),tmpColorNode.green(),tmpColorNode.blue(),0);}
Color  View3DSetup::getEdgeColor(){return Color(tmpColorEdge.red(),tmpColorEdge.green(),tmpColorEdge.blue(),0);}
void View3DSetup::setColorMapping(const QString &str) {tmpColorMapping=str.ascii();}
