dnl ------------------------------------------------------------------------
dnl Find a file (or one of more files in a list of dirs)
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_FIND_FILE,
[
$3=NO
for i in $2;
do
  for j in $1;
  do
    if test -r "$i/$j"; then
      $3=$i
      break 2
    fi
  done
done
])

AC_DEFUN(FIND_PATH,
[
   AC_MSG_CHECKING([for $1])
   AC_CACHE_VAL(kde_cv_path_$1,
   [
     kde_cv_path_$1="NONE"
     if test -n "$$2"; then
        kde_cv_path_$1="$$2";
     else
	dirs="$3"
	kde_save_IFS=$IFS
	IFS=':'
	for dir in $PATH; do
	  dirs="$dirs $dir"
        done
	IFS=$kde_save_IFS

        for dir in $dirs; do
	  if test -x "$dir/$1"; then
	    if test -n "$5"
	    then
              evalstr="$dir/$1 $5 2>&1 "
	      if eval $evalstr; then
                kde_cv_path_$1="$dir/$1"
                break
	      fi
            else
		kde_cv_path_$1="$dir/$1"
                break
	    fi
          fi
	done

     fi
         
   ])

   if test -z "$kde_cv_path_$1" || test "$kde_cv_path_$1" = "NONE"; then
      AC_MSG_RESULT(not found)
      $4
   else 
     AC_MSG_RESULT($kde_cv_path_$1)
     $2=$kde_cv_path_$1
   fi
])

dnl ------------------------------------------------------------------------
dnl Try to find the Open GL headers and libraries.
dnl $(GL_LDFLAGS) will be -Lglliblocation (if needed)
dnl and $(GL_INCLUDES) will be -Iglheaderlocation (if needed)
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_PATH_GL,
[
AC_REQUIRE([AC_PATH_X])
LIB_GL="-lGL -lGLU -lglut"
AC_MSG_CHECKING([for Open Gl])

ac_gl_includes="" ac_gl_libraries=""

AC_ARG_WITH(gl-includes,
    [  --with-gl-includes=DIR   where the OpenGL includes are. ],
    [  ac_gl_includes="$withval"
    ])

AC_ARG_WITH(gl-libraries,
    [  --with-gl-libraries=DIR where the OpenGL libraries are. ],
    [  ac_gl_libraries="$withval"
    ])

AC_CACHE_VAL(ac_cv_have_gl,
[
gl_incdirs=" $ac_gl_includes $GLDIR/include /usr/include /usr/X11R6/include/X11 /usr/X11R6/include $x_includes "
AC_FIND_FILE(GL/gl.h, $gl_incdirs, gl_incdir)
ac_gl_includes="$gl_incdir"

gl_libdirs="$ac_gl_libraries $GLLIB /usr/X11R6/lib /usr/lib /usr/local/lib $x_libraries "
test -n "$GLDIR" && gl_libdirs="$GLDIR/lib $GLDIR $gl_libdirs"
test=NONE
gl_libdir=NONE
for dir in $gl_libdirs; do
  try="ls -1 $dir/libGL*"
  if test=`eval $try 2> /dev/null`; then gl_libdir=$dir; break; else echo "tried $dir" >&AC_FD_CC ; fi
done
ac_gl_libraries="$gl_libdir"

 GL_INCLUDES="-I$ac_gl_includes"
 GL_LDFLAGS="-L$ac_gl_libraries"
])

eval "$ac_cv_have_gl"
if test "$ac_gl_libraries" = NONE; then
  AC_MSG_ERROR([ Not found , put your GLDIR environnement variable to the OpenGL directory ]);
else
  ac_cv_have_gl="have_gl=yes \
  ac_gl_includes=$ac_gl_includes ac_gl_libraries=$ac_gl_libraries"
  AC_MSG_RESULT([ libraries $ac_gl_libraries, headers $ac_gl_includes ])  
  gl_libraries="$ac_gl_libraries"
  gl_includes="$ac_gl_includes"
  GL_INCLUDES="-I$ac_gl_includes"	
  GL_LDFLAGS="-L$ac_gl_libraries"
fi

AC_SUBST(gl_libraries)
AC_SUBST(gl_includes)
AC_SUBST(GL_INCLUDES)
AC_SUBST(GL_LDFLAGS)

LIB_GL="-lGL -lGLU -lglut"
AC_SUBST(LIB_GL)
])
