#ifndef TLPGLDRAWABLE_H
#define TLPGLDRAWABLE_H

#include <set>
class GlGraph;

struct GlDrawable {
  virtual ~GlDrawable(){}
  virtual void draw(GlGraph *) = 0;
};


struct GlDrawableComposite : public GlDrawable {
  virtual ~GlDrawableComposite();
  void draw(GlGraph *);
  void add(GlDrawable *);
  void del(GlDrawable *);
private:
  std::set<GlDrawable *> elements;
};


#endif
