#ifndef _RENDU_H_
#define _RENDU_H_

#include <string>

#include "Document.h"
#include "Context.h"
#include "Parser.h"

typedef enum TextMode{XML,VERBATIM};

class Rendu{
  
  Document* doc;
  Context c;

  void initTextManager(std::string str);
  Paragraph* textXMLManager(Document* d, Paragraph* f, char* text);
  void initTextXMLManager(Parser* P, xmlNodePtr courant, Document* d);
  void finalTextXMLManager(Paragraph* f);

 public:
  Rendu();
  ~Rendu();

  void draw(float w_max, float& w) const;
  void getBoundingBox(float w_max, float& h, float& w) const;

  void setString(std::string str, TextMode mode);
  void setContext(std::string str, int s, unsigned char r, unsigned char v, unsigned char b);
};


#endif


