#include "tulip/DynamicFunctionsGl.h"
#include <GL/gl.h>
#include <GL/glu.h>

#include <iostream>

using namespace std;

void DynamicFunctionsGl::translate(float x, float y, float z){
  switch(mode){
  case BITMAP:
  case PIXMAP:
  case TLPPIXMAP:
    glBitmap(0,0,0,0, x,y, 0);
    break;
  case OUTLINE:
  case POLYGON:
  case EXTRUDE:
  case TEXTURE:
    glTranslatef(x,y,z);
    break;
  }
}


void DynamicFunctionsGl::setColor(unsigned char r, unsigned char v, unsigned char b){
  glColor4ub(r, v, b ,255);
}

void DynamicFunctionsGl::drawLine(float x1, float y1, float z1, float x2, float y2, float z2){
  switch(mode){
  case BITMAP:
  case PIXMAP:
  case TLPPIXMAP:
    GLfloat color[3];

    glGetFloatv(GL_CURRENT_COLOR, color);

    glBitmap(0, 0, 0, 0, x1, y1, 0);

    if(x1 == x2){
      int inc;
      float dy = abs(y1-y2);
      if( y1 > y2) inc = -1;
      else inc = +1;
      for(int i=0; i<dy; i++){
	glDrawPixels(1, 1, GL_RGB, GL_FLOAT, color);
	glBitmap(0, 0, 0, 0, 0, inc, 0);
      }
      glBitmap(0, 0, 0, 0, 0,-1*inc*dy, 0);
    }
    else{
      int inc;
      float dx = abs(x1-x2);
      if( x1 > x2 ) inc = -1;
      else inc = +1;
      for(int i=0; i<dx; i++){
	glDrawPixels(1, 1, GL_RGB, GL_FLOAT, color);
	glBitmap(0, 0, 0, 0, inc, 0, 0);
      } 
      glBitmap(0, 0, 0, 0, -1*inc*dx,0, 0);
    }
    
    glBitmap(0, 0, 0, 0, -x1, -y1, 0);

    break;
  case OUTLINE:
  case POLYGON:
  case EXTRUDE:
     glBegin(GL_LINES);
     glVertex3f(x1, y1, z1);
     glVertex3f(x2, y2, z2);
     glEnd();
     break;
  case TEXTURE:
    glDisable(GL_BLEND);
    glBegin(GL_LINES);
    glVertex3f(x1, y1, z1);
    glVertex3f(x2, y2, z2);
    glEnd();
    glEnable(GL_BLEND);
  }
}

