#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qpopupmenu.h>
#include <qtimer.h>
#include <qtextview.h>
#include <qimage.h>
#include <qmutex.h>

#include <tulip/SuperGraph.h>
#include <tulip/Iterator.h>
#include <tulip/SelectionProxy.h>
#include <tulip/LayoutProxy.h>
#include <tulip/GlGraph.h>

#include "tulip/MouseInterface.h"
#include "tulip/GlGraphWidget.h"

using namespace std;
using namespace tlp;
QMutex mutex;

QGLFormat GlInit() {
  QGLFormat tmpFormat;
  tmpFormat.setDirectRendering(true);
  tmpFormat.setDoubleBuffer(true);
  tmpFormat.setAccum(false);
  tmpFormat.setStencil(false);
  tmpFormat.setOverlay(false);
  tmpFormat.setDepth(true);
  tmpFormat.setRgba(true);
  tmpFormat.setAlpha(true);
  return tmpFormat;
}

//==================================================
GlGraphWidget::GlGraphWidget(QWidget *parent, const char *name):
  QGLWidget(GlInit(),parent, name),
  drawTimer(new QTimer(this)),
  mouse(0),
  external(0) {
  //  cerr << __PRETTY_FUNCTION__ << endl;
  setAutoBufferSwap(false);  
  TRACE_EXEC();
  glGraph = new GlGraph(*this);
  connect(drawTimer, SIGNAL(timeout()), this, SLOT(drawGraph()));
  setFocusPolicy(QWidget::StrongFocus);
}
//==================================================
GlGraphWidget::GlGraphWidget(const GlGraphWidget &w, QWidget *parent, const char *name):
  QGLWidget(GlInit(),parent, name),
  drawTimer(new QTimer(this)),
  mouse(0),
  external(0) {
  TRACE_EXEC();
  connect(drawTimer, SIGNAL(timeout()), this, SLOT(drawGraph()));
  glGraph = new GlGraph(*this, *w.getGlGraph());
  setFocusPolicy(QWidget::StrongFocus);
}
//==================================================
GlGraphWidget::~GlGraphWidget() {
  delete drawTimer;
  delete glGraph;
  if (external != 0 ) delete external;
}
//==================================================
/*
void GlGraphWidget::setGlGraph(GlGraph *g) {
  TRACE_EXEC();
  exit(1);
  setUpdatesEnabled(false);
  if (glGraph != NULL) delete glGraph;
  glGraph = g;
  setUpdatesEnabled(true);
  redraw();
}
*/
//==================================================
void GlGraphWidget::setExternal(GlDrawable *ext) {
  external=ext;
} 
//==================================================
GlDrawable* GlGraphWidget::getExternal() {
  return external;
}
//==================================================
GlGraph *GlGraphWidget::getGlGraph() const {
  return glGraph;
}
//==================================================
//GlGraphStrategy
//==================================================
void GlGraphWidget::MakeCurrent() {
  //  cerr << __PRETTY_FUNCTION__ << " (" << (int)this << ")" << endl;
  assert(context()->isValid());
  makeCurrent();
}
//==================================================
void GlGraphWidget::UpdateGL() {
  //  cerr << __PRETTY_FUNCTION__ << endl;
  glDraw();
}
//==================================================
void GlGraphWidget::redraw() {
  //  cerr << __PRETTY_FUNCTION__ << endl;
  if (glGraph ==0) return; 
  glGraph->draw();
}
//==================================================
bool GlGraphWidget::timerIsActive() {
  return drawTimer->isActive();
}
//==================================================
int GlGraphWidget::timerStart(int msec, bool sshot) {
  return drawTimer->start(msec, sshot);
}
//==================================================
void GlGraphWidget::timerStop() {
  drawTimer->stop();
}
//==================================================
void GlGraphWidget::mPaint(GlGraph *g) {
  makeCurrent();
  if (external!=0) external->draw(g);
  if (mouse != NULL) mouse->mPaint(this);
}
//==================================================
void GlGraphWidget::clickAt(int x, int y) {
  node tmpNode;
  edge tmpEdge;
  ElementType type;  
  if (glGraph->doSelect(x, y, type, tmpNode, tmpEdge)) {
    switch(type) {
    case NODE: emit nodeClicked(glGraph->getSuperGraph(), tmpNode); break;
    case EDGE: emit edgeClicked(glGraph->getSuperGraph(), tmpEdge); break;
    }
  }
}
//==================================================
void GlGraphWidget::clickAt(const QPoint &pos) { 
  clickAt(pos.x(), pos.y()); 
}
//==================================================
void GlGraphWidget::setSuperGraph(SuperGraph *sg) {
  //  cerr << __PRETTY_FUNCTION__ << endl;
  if (glGraph == 0) return;
  TRACE_EXEC();
  glGraph->setSuperGraph(sg);
  glGraph->centerScene();
  toUpdate=true;
}
//==================================================
SuperGraph *GlGraphWidget::getSuperGraph() const {
  if (glGraph != 0) 
    return glGraph->getSuperGraph();
  else 
    return NULL;
}
//==================================================
MouseInterface *GlGraphWidget::getMouse() const {
  return mouse;
}
//==================================================
void GlGraphWidget::setMouse(MouseInterface *m) {
  mouse = m;
}
//==================================================
//QGLWidget
//==================================================
QImage GlGraphWidget::grabFrameBuffer(bool withAlpha) {
  bool incState = glGraph->isIncrementalRendering();
  glGraph->setIncrementalRendering(false);
  this->updateGL();
  QImage img = QGLWidget::grabFrameBuffer(withAlpha);
  glGraph->setIncrementalRendering(incState);
  return img;
}
//==================================================
//QGLWidget slots
//==================================================
void GlGraphWidget::initializeGL() {
  //  cerr << __PRETTY_FUNCTION__ << endl;
  glGraph->initializeGL();
}
//==================================================
void GlGraphWidget::paintGL() {
  TRACE_EXEC();
  makeCurrent();
  glGraph->draw();
  if (!glGraph->isIncrementalRendering()) 
    swapBuffers();
  else
    drawGraph();
}
//==================================================
void GlGraphWidget::resizeGL(int w, int h) {
  TRACE_EXEC();
  if (glGraph != NULL) 
    glGraph->changeViewport(0,0,w,h);
}
//==================================================
void GlGraphWidget::drawGraph() {
  TRACE_EXEC();
  makeCurrent();
  if (glGraph != NULL) {
    if (glGraph->drawPart()) timerStop();
    swapBuffers();
  }
}
//==========================================================
// FIXME : This piece of code should be removed  
//==========================================================
void GlGraphWidget::deleteElement(int x, int y) {
  if (glGraph == NULL) return;
  drawTimer->stop();
  bool result;
  ElementType type;
  node tmpNode;
  edge tmpEdge;
  Observable::holdObservers();
  result = glGraph->doSelect(x, y, type, tmpNode, tmpEdge);
  bool strahler=glGraph->isViewStrahler();
  glGraph->setViewStrahler(false);
  if(result==true) {
    switch(type) {
    case NODE: glGraph->getSuperGraph()->delNode(tmpNode); break;
    case EDGE: glGraph->getSuperGraph()->delEdge(tmpEdge); break;
    }
  }
  glGraph->setViewStrahler(strahler);
  redraw();
  Observable::unholdObservers();
}
//==========================================================
// FIXME : This piece of code should be removed  
//==========================================================
void GlGraphWidget::setContextCoord(int x, int y) {
  xContext = x;
  yContext = y;
}

void GlGraphWidget::contextDel() {
  deleteElement(xContext,yContext);
}
//==========================================================
// FIXME : This piece of code should be removed  
//==========================================================
void GlGraphWidget::contextSelect() {
  if (glGraph == NULL) return;
  Observable::holdObservers();
  bool result;
  ElementType type;
  node tmpNode;
  edge tmpEdge;
  SelectionProxy *elementSelected=glGraph->getSuperGraph()->getProperty<SelectionProxy>("viewSelection");
  elementSelected->setAllNodeValue(false);
  elementSelected->setAllEdgeValue(false);
  result=glGraph->doSelect(xContext,yContext,type,tmpNode,tmpEdge);
  if (result==true) {
    switch(type) {
    case NODE: elementSelected->setNodeValue(tmpNode, true); break;
    case EDGE: elementSelected->setEdgeValue(tmpEdge, true); break;
    }
  }
  Observable::unholdObservers();
}
//==========================================================
// FIXME : This piece of code should be removed  
//==========================================================
void GlGraphWidget::contextProperties() {
  node tmpNode;
  edge tmpEdge;
  ElementType type;
  
  if (glGraph->doSelect(xContext, yContext, type, tmpNode, tmpEdge)) {
    switch(type) {
    case NODE: emit nodeClicked(glGraph->getSuperGraph(), tmpNode); break;
    case EDGE: emit edgeClicked(glGraph->getSuperGraph(), tmpEdge); break;
    }
  }
}
//==========================================================
// FIXME : This piece of code should be removed  
//==========================================================
void GlGraphWidget::contextAddRemoveSelection() {
  if (glGraph == NULL) return;
  Observable::holdObservers();
  bool result;
  ElementType type;
  node tmpNode;
  edge tmpEdge;
  SelectionProxy *elementSelected=glGraph->getSuperGraph()->getProperty<SelectionProxy>("viewSelection");
  result=glGraph->doSelect(xContext, yContext, type, tmpNode, tmpEdge);
  if (result==true) {
    switch(type) {
    case NODE: elementSelected->setNodeValue(tmpNode, !elementSelected->getNodeValue(tmpNode)); break;
    case EDGE: elementSelected->setEdgeValue(tmpEdge, !elementSelected->getEdgeValue(tmpEdge)); break;
    }
    redraw();
  }
  Observable::unholdObservers();
}
//==========================================================
// FIXME : This piece of code should be removed  
//==========================================================
void GlGraphWidget::delSelection() {
  if (glGraph == NULL) return;
  Iterator<node> *itN=glGraph->getSuperGraph()->getNodes();
  Iterator<edge> *itE=glGraph->getSuperGraph()->getEdges();
  list<node> tmpListN;
  list<edge> tmpListE;
  SelectionProxy *elementSelected=glGraph->getSuperGraph()->getProperty<SelectionProxy>("viewSelection");
  bool strahler=glGraph->isViewStrahler();
  glGraph->setViewStrahler(false);
  Observable::holdObservers();
  for(; itE->hasNext();) {
    edge ite=itE->next();
    if (elementSelected->getEdgeValue(ite)==true)   
      tmpListE.push_back(ite);
  } delete itE;
  for(; itN->hasNext();) {
    node itv=itN->next();
    if (elementSelected->getNodeValue(itv)==true)
      tmpListN.push_back(itv);
  } delete itN;
  while (!tmpListE.empty()) {
    glGraph->getSuperGraph()->delEdge(tmpListE.front());
    tmpListE.pop_front();
  }
  while (!tmpListN.empty()) {
    glGraph->getSuperGraph()->delNode(tmpListN.front());
    tmpListN.pop_front();
  }
  glGraph->setViewStrahler(strahler);
  redraw();
  Observable::unholdObservers();
}

//=====================================================
// Events 
//=====================================================
void GlGraphWidget::mousePressEvent(QMouseEvent *e) {
  if (mouse != NULL) 
    mouse->mPressEvent(this, e);
  else {
    if (e->button()==QEvent::LeftButton) {
      node tmpNode;
      edge tmpEdge;
      ElementType type;
      if (getGlGraph()->doSelect(e->x(), e->y(), type, tmpNode,tmpEdge)) {
	switch(type) {
	case NODE: emit nodeClicked(glGraph->getSuperGraph(), tmpNode); break;
	case EDGE: emit edgeClicked(glGraph->getSuperGraph(), tmpEdge); break;
	}
      }
    }
  }
}
//================================================
void GlGraphWidget::mouseMoveEvent(QMouseEvent *e) {
  if (mouse != NULL) mouse->mMoveEvent(this, e);
}

void GlGraphWidget::mouseReleaseEvent(QMouseEvent *e) {
  if (mouse != NULL) mouse->mReleaseEvent(this ,  e);
}

void GlGraphWidget::keyPressEvent(QKeyEvent *e) {
  if (mouse != NULL) mouse->keyPressEvent(this, e);
}

void GlGraphWidget::keyReleaseEvent(QKeyEvent *e) {
  if (mouse != NULL) mouse->keyReleaseEvent(this, e);
}

void GlGraphWidget::wheelEvent(QWheelEvent *e) {
  if (mouse != NULL) mouse->wheelEvent(this, e);
}
