#include <iostream>

#include <qstringlist.h>
#include <qwidgetplugin.h>

#include "tulip/SuperGraph.h"
#include "tulip/TlpTools.h"
#include "tulip/PropertyWidgets.h"
#include "tulip/GlGraphWidget.h"
#include "tulip/TulipElementProperties.h"
#include "tulip/ClusterTree.h"

#include "../designer/clustertree.xpm"
#include "../designer/elementtable.xpm"
#include "../designer/GlGraphWidget.xpm"


using namespace std;

class QT_WIDGET_PLUGIN_EXPORT TulipWidgetsPlugin : public QWidgetPlugin
{
public:
  TulipWidgetsPlugin();
  ~TulipWidgetsPlugin();
  
  QStringList keys() const;
  QWidget* create( const QString &classname, QWidget* parent = 0, const char* name = 0 );
  QString group( const QString& ) const;
  QIconSet iconSet( const QString& ) const;
  QString includeFile( const QString& ) const;
  QString toolTip( const QString& ) const;
  QString whatsThis( const QString& ) const;
  bool isContainer( const QString& ) const;

private:
  SuperGraph *supergraph;
};

TulipWidgetsPlugin::TulipWidgetsPlugin() { supergraph = tlp::newSuperGraph(); }
TulipWidgetsPlugin::~TulipWidgetsPlugin() { delete supergraph; }

QStringList TulipWidgetsPlugin::keys() const {
  QStringList list;
  list << "TulipPropertyTable";
  list << "TulipElementProperties";
  list << "GlGraphWidget";
  list << "ClusterTree";
  return list;
}

QWidget* TulipWidgetsPlugin::create(const QString &key, QWidget* parent, const char* name) {
  if (key == "TulipPropertyTable") return new TulipPropertyTable(parent, name);
  if (key == "TulipElementProperties") return new TulipElementProperties(NULL, QStringList(), QStringList(), parent, name);
  if (key == "GlGraphWidget") return new GlGraphWidget(parent, name);
  if (key == "ClusterTree") return new ClusterTree(supergraph, parent, name);
  return 0;
}

QString TulipWidgetsPlugin::includeFile(const QString& feature) const {
  if (feature == "TulipPropertyTable") return "tulip/PropertyWidgets.h";
  if (feature == "TulipElementProperties") return "tulip/TulipElementProperties.h";
  if (feature == "GlGraphWidget") return "tulip/GlGraphWidget.h";
  if (feature == "ClusterTree") return "tulip/ClusterTree.h";
  return QString::null;
}

QString TulipWidgetsPlugin::group(const QString& feature) const {
  if ((feature == "TulipPropertyTable")
      || (feature == "GlGraphWidget")
      || (feature == "TulipElementProperties")
      || (feature == "ClusterTree"))
    return "Tulip";
  return QString::null;
}

QIconSet TulipWidgetsPlugin::iconSet(const QString& feature) const {
  if (feature == "TulipPropertyTable") return QIconSet(QPixmap(elementtable_xpm));
  if (feature == "GlGraphWidget") return QIconSet(QPixmap(GlGraphWidget_xpm));
  if (feature == "TulipElementProperties") return QIconSet(QPixmap(elementtable_xpm));
  if (feature == "ClusterTree") return QIconSet(QPixmap(clustertree_xpm));
  return QIconSet();
}

QString TulipWidgetsPlugin::toolTip(const QString& feature) const {
  if (feature == "TulipPropertyTable") return tr("Element Table Widget");
  if (feature == "TulipElementProperties") return tr("Node Properties Widget");
  if (feature == "GlGraphWidget") return tr("GlGraph Widget");
  if (feature == "ClusterTree") return tr("Cluster Tree");
  return QString::null;
}

QString TulipWidgetsPlugin::whatsThis(const QString& feature) const {
  if (feature == "TulipPropertyTable") return tr("A widget to display Tulip's properties");
  if (feature == "TulipElementProperties") return tr("A widget to display properties of a node");
  if (feature == "GlGraphWidget") return tr("A widget containing a Tulip GlGraph");
  if (feature == "ClusterTree") return tr("A widget displaying a tree of all clusters present in a SuperGraph");
  return QString::null;
}

bool TulipWidgetsPlugin::isContainer(const QString& feature) const {
  if (feature == "TulipPropertyTable") return false;
  if (feature == "TulipElementProperties") return false;
  if (feature == "GlGraphWidget") return false;
  if (feature == "ClusterTree") return false;
  return false;
}

Q_EXPORT_PLUGIN(TulipWidgetsPlugin);
