//@TLPGEOLICENCE#

#ifndef _TLP_GEO_MATRIX_H
#define _TLP_GEO_MATRIX_H
#include <cassert>
#include <iostream>
#include <tulip/Vector.h>

#define MATRIX Matrix<Obj,SIZE>


namespace tlp {
  /**
   * \addtogroup basic
   */ 
  /*@{*/
  /**
     * \brief class for mathematical square matrix
     *
     * Enables to create a Square Matrix of Obj with a
     * Fixed size and provide Mathematical operation. Mathematical 
     * operators must be defined for Obj. 
     *
     * Author : <a href="mailto:auber@tulip-software.org>David Auber</A>
     * Version 0.0.1 24/01/2003 
     */
    template<typename Obj,int SIZE>
    class Matrix:public Vector< Vector<Obj,SIZE> , SIZE >
    {
    public:
      Matrix(){}
      Matrix(const MATRIX &a):Vector< Vector<Obj,SIZE> , SIZE >(a){};
      /**
       * Fill the matrix with the value of obj
       */
      inline MATRIX& fill(Obj obj);
      /**
       * Compute the determinant of the matrix,
       */
      Obj determinant();
      /**
       * Transpose the matrix and return "&(*this)".
       */
      MATRIX& transpose();
      /**
       * Inverse the matrix and return "&(*this)"
       */
      MATRIX& inverse();
      /**
       * Multiply the matrix by another matrix and return "&(*this)"
       */
      inline MATRIX & operator*=(const MATRIX &mat);
      /**
       *  Divide all element of the matrix by obj and return "&(*this)"
       */
      inline MATRIX & operator/=(const Obj &obj);
      /**
       * Return the cofactor Matrix of this
       */
      MATRIX cofactor();
      /**
       * Return a new matrix equal to the multiplication of the matrix by 
       * another matrix"
       */
      MATRIX operator*(const MATRIX &mat2);
      /**
       * Return a new vector equal to the multiplication of the matrix by 
       * a vector"
       */
      inline Vector<Obj,SIZE> operator*(const Vector<Obj,SIZE> &vec);
    };
    /*@}*/
}

#include "./cxx/Matrix.cxx"
#endif
