//-*-c++-*-
#ifndef _TLPTOOLS_H
#define _TLPTOOLS_H

#include "SuperGraph.h"
#include "LayoutProxy.h"
#include "MetricProxy.h"
#include "StringProxy.h"
#include "SelectionProxy.h"
#include "ColorsProxy.h"
#include "IntProxy.h"
#include "SizesProxy.h"
#include "PluginProgress.h"
#include "Reflect.h"

namespace tlp {
  extern std::string TulipLibDir;
  extern std::string TulipPluginsPath;
  
  extern void initTulipLib();
    
  extern TemplateFactory<ClusteringFactory,Clustering,ClusterContext > clusteringFactory;
  extern TemplateFactory<ImportModuleFactory,ImportModule,ClusterContext > importFactory;
  extern TemplateFactory<ExportModuleFactory,ExportModule,ClusterContext > exportFactory;
  void loadPlugins(PluginLoader *plug=0);

  /*<<<<<<< TlpTools.h
  template<typename PLUGINTYPE>
  void loadPlugin(std::string filename) {
  }
  */
  /*
   * Load a graph in the tlp format
   * Warning : this function use "tlp" import plugin (must be laoded)
   */
  SuperGraph * load(const std::string &filename);
  /*
   * Save a graph in tlp format
   * Warning : this function use "tlp" export plugin (must be laoded)
   */
  bool save(SuperGraph *, const std::string &filename);
  SuperGraph * importGraph(const std::string &alg, DataSet &dataSet, PluginProgress *plugProgress=0,SuperGraph *newSuperGraph=0);
  bool exportGraph(SuperGraph *sg,std::ostream  &os,const std::string &alg, DataSet &dataSet, PluginProgress *plugProgress=0);
  bool clusterizeGraph(SuperGraph *sg,std::string &errorMsg, DataSet *dataSet =0,const std::string &alg="hierarchical" , PluginProgress *plugProgress=0);
  /**
   * Return a new graph
   */
  SuperGraph* newSuperGraph();
  /**
   *  Return an empty subgraph 
   */
  SuperGraph *newSubGraph(SuperGraph *, std::string name = "unnamed");
  /**
   *  Return a subgraph induced by a set of nodes
   */
  SuperGraph *inducedSubGraph(SuperGraph *, const std::set<node> &, std::string name = "induced subgraph");
  /**
   *  Return a subgraph equal to the graph given in parameter (a clone subgraph)
   */
  SuperGraph *newCloneSubGraph(SuperGraph *, std::string name = "unnamed");
  /**
   *  find the first node of degree 0, if no node exist return false else true
   */
  bool getSource(SuperGraph *, node &n);
  /**
   * Return an istream from a gzipped file (uses gzstream lib)
   * the stream has to be deleted after use.
   * \warning Don't forget to check the stream with ios::bad()!
   */
  std::istream *getIgzstream(const char *name, int open_mode = std::ios::in);
  /**
   * Return an ostream to write to a gzipped file (uses gzstream lib)
   * the stream has to be deleted after use.
   * \warning Don't forget to check the stream with ios::bad()!
   */
  std::ostream *getOgzstream(const char *name, int open_mode = std::ios::out);
  /**
   * Append the selected part of the graph inG (properties, nodes & edges) into the graph outG.
   * If no selection is done (inSel=NULL), the whole inG graph is appended.
   * The output selection is used to select the appended nodes & edges
   * \warning The input selection is extended to all selected edge ends.
   */
  void copyToGraph( SuperGraph * outG, SuperGraph *	inG, SelectionProxy* inSelection=0, SelectionProxy* outSelection=0 );
  /**
   * Remove the selected part of the graph ioG (properties, nodes & edges).
   * If no selection is done (inSel=NULL), the whole graph is reseted to default value.
   * \warning The selection is extended to all selected edge ends.
   */
  void removeFromGraph(	SuperGraph * ioG, SelectionProxy* inSelection = 0 );
  
};

#endif
