//-*-c++-*-
#ifndef TYPES_H
#define TYPES_H

#include <vector>
#include <string>
#include <list>
#include <iostream>
#include <sstream>
#include <float.h>
#include "Coord.h"
#include "Size.h"
#include "Color.h"

class SuperGraph;

/**
 * \defgroup types
 */ 
/*@{*/

///
class Type {
public:
  Type(){};
  ~Type();
};

class MetaGraphType:public Type {
public:
  typedef SuperGraph* RealType;
  static MetaGraphType::RealType undefineValue();
  static MetaGraphType::RealType defaultValue();
  static void  del(MetaGraphType::RealType element);
  static std::string toString( const RealType & v );
  static bool fromString( RealType & v, const std::string & s );
};


///
class DoubleType:public Type {
public:
  typedef double RealType;
  static double undefineValue();
  static double defaultValue();
  static void  del(DoubleType::RealType element);
  static std::string toString( const RealType & v );
  static bool fromString( RealType & v, const std::string & s );
};


///
class IntType:public Type
{
public:
  typedef int RealType;
  static int undefineValue();
  static int defaultValue();
  static void  del(IntType::RealType element);
  static std::string toString( const RealType & v );
  static bool fromString( RealType & v, const std::string & s );
};


///
class BooleanType:public Type {
public:
  typedef bool RealType;
  static bool undefineValue();
  static bool defaultValue();
  static void del(BooleanType::RealType element);
  static std::string toString( const RealType & v );
  static bool fromString( RealType & v, const std::string & s );
};


///
class LineType:public Type
{
public:
  typedef std::vector<Coord> RealType;
  static std::vector<Coord> undefineValue();
  static std::vector<Coord> defaultValue();
  static void del(LineType::RealType &element);
  static std::string toString( const RealType & v );
  static bool fromString( RealType & v, const std::string & s );
};


///
class PointType:public Type {
public:
  typedef  Coord RealType;
  static Coord undefineValue();
  static Coord defaultValue();
  static void del(PointType::RealType element);
  static std::string toString( const RealType & v );
  static bool fromString( RealType & v, const std::string & s );
};


///
class SizeType:public Type {
public:
  typedef  Size RealType;
  static Size undefineValue();
  static Size defaultValue();
  static void del(SizeType::RealType element);
  static std::string toString( const RealType & v );
  static bool fromString( RealType & v, const std::string & s );
};


///
class StringType:public Type {
public:
  typedef std::string RealType;
  static std::string undefineValue();
  static std::string defaultValue();
  static void del(StringType::RealType element);
  static std::string toString( const RealType & v );
  static bool fromString( RealType & v, const std::string & s );
};


///
class ColorType:public Type {
public:
  typedef Color RealType;
  static Color undefineValue();
  static Color defaultValue();
  static void del(ColorType::RealType element);
  static std::string toString( const RealType & v );
  static bool fromString( RealType & v, const std::string & s );
};


/*@}*/
#endif









