#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <float.h>
#include "tulip/MetaGraphProxy.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/MetaGraph.h"
#include "tulip/PropertyProxy.h"
#include "tulip/MethodFactory.h"

using namespace std;

//==============================
///Constructeur d'un MetaGraphProxy
MetaGraphProxy::MetaGraphProxy (SuperGraph *graph) : 
  PropertyProxy<MetaGraphType,MetaGraphType>(graph) {
  //  propertyProxy=this;
}
//==============================
///Destructeur d'un metaGraph Proxy  
///Vide pour l'instant, cela peut
///provoquer des fuites m�moires
MetaGraphProxy::~MetaGraphProxy() {}    
//========================================================================
///Poign� permettnet le reset des variables du MetaGraphProxy par le PropertyProxy
void MetaGraphProxy::reset_handler(){}
//=============================================================================
///Poign� permettnet le recompute il faut absolument mettre le graphProperties
///currentMetaGraphProxy � this sinon le r�sultat est impr�visible
void MetaGraphProxy::recompute_handler() {
  //  superGraph->getPropertyManager()->currentPropertyProxy=this;
}
//=================================================================================
void MetaGraphProxy::clone_handler(PropertyProxy<MetaGraphType,MetaGraphType> &proxyC)
{}


//=================================================================================
PProxy* MetaGraphProxy::clonePrototype(SuperGraph * g, std::string n)
{
	if( !g )
		return 0;
	MetaGraphProxy * p = g->getLocalProperty<MetaGraphProxy>( n );
	p->setAllNodeValue( getNodeDefaultValue() );
	p->setAllEdgeValue( getEdgeDefaultValue() );
	return p;
}
//=============================================================
void MetaGraphProxy::copy( const node n0, const node n1, PProxy * p )
{
	if( !p )
		return;
	MetaGraphProxy * tp = dynamic_cast<MetaGraphProxy*>(p);
	assert( tp );
	setNodeValue( n0, tp->getNodeValue(n1) );
}
//=============================================================
void MetaGraphProxy::copy( const edge e0, const edge e1, PProxy * p )
{
	if( !p )
		return;
	MetaGraphProxy * tp = dynamic_cast<MetaGraphProxy*>(p);
	assert( tp );
	setEdgeValue( e0, tp->getEdgeValue(e1) );
}









