#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cassert>
#include <iostream>
#include "tulip/ObservableGraph.h"

using namespace std;

void ObservableGraph::notifyAddNode(SuperGraph *graph, const node n) {
  for (set<GraphObserver *>::iterator itlObs=observers.begin();itlObs!=observers.end();++itlObs)
    (*itlObs)->addNode(graph, n);
}

void ObservableGraph::notifyDelNode(SuperGraph *graph, const node n) {
  for (set<GraphObserver *>::iterator itlObs=observers.begin();itlObs!=observers.end();++itlObs)
    (*itlObs)->delNode(graph, n);
}

void ObservableGraph::notifyAddEdge(SuperGraph *graph, const edge e) {
  for (set<GraphObserver *>::iterator itlObs=observers.begin();itlObs!=observers.end();++itlObs)
    (*itlObs)->addEdge(graph, e);
}

void ObservableGraph::notifyDelEdge(SuperGraph *graph, const edge e) {
  for (set<GraphObserver *>::iterator itlObs=observers.begin();itlObs!=observers.end();++itlObs)
    (*itlObs)->delEdge(graph, e);
}

void ObservableGraph::notifyReverseEdge(SuperGraph *graph, const edge e) {
  for (set<GraphObserver *>::iterator itlObs=observers.begin();itlObs!=observers.end();++itlObs)
    (*itlObs)->reverseEdge(graph, e);
}

void ObservableGraph::notifyDestroy(SuperGraph *graph) {
  for (set<GraphObserver *>::iterator itlObs=observers.begin();itlObs!=observers.end();++itlObs)
    (*itlObs)->destroy(graph);
}

