#include <qfiledialog.h>
#include <tulip/TulipPlugin.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>

using namespace std;

struct FileSystem:public ImportModule
{
  FileSystem(ClusterContext context):ImportModule(context) {}
  ~FileSystem(){}

  MetricProxy *size,*gid,*uid,*lastaccess,*lastmodif,*lastchange;

  IntProxy *type;
  StringProxy *label;
  bool breaked;
  int progress;


    bool readDir(node n,string directory) {
    if (!pluginProgress->progress(progress,100)) { breaked=true; return false;}
    progress++;
    progress=progress%100;
    if (breaked) return false;
    DIR *dir=opendir(directory.c_str());
    if (dir==0) return false;
    dirent *entry;
    struct stat infoEntry;
    int i=0;
    while ((entry = readdir(dir))!=0) {
      if (!strcmp("..",entry->d_name) || !strcmp(".",entry->d_name)) continue;
      string entryName=entry->d_name;
      string pathEntry=directory+entryName;
      lstat(pathEntry.c_str(),&infoEntry);
      if (infoEntry.st_dev==true) continue;
      node newNode=superGraph->addNode();
      superGraph->addEdge(n,newNode);
      label->setNodeValue(newNode,entryName);
      if (infoEntry.st_size<1)
	size->setNodeValue(newNode,1);
      else
	size->setNodeValue(newNode,infoEntry.st_size);
      uid->setNodeValue(newNode,infoEntry.st_uid);
      gid->setNodeValue(newNode,infoEntry.st_gid);
      lastaccess->setNodeValue(newNode,infoEntry.st_atime);
      lastmodif->setNodeValue(newNode,infoEntry.st_mtime);
      lastchange->setNodeValue(newNode,infoEntry.st_ctime);
      
      if ((infoEntry.st_mode & S_IFMT) == S_IFDIR) {
	type->setNodeValue(newNode,1);
	if (!readDir(newNode,pathEntry+"/"))
	  superGraph->delNode(newNode);
	else {
	  double newSize=0;
	  Iterator<node> *itN=superGraph->getOutNodes(newNode);
	  for (;itN->hasNext();) {
	    node itn=itN->next();
	    newSize+=size->getNodeValue(itn);
	  }
	  delete itN;
	  size->setNodeValue(newNode,newSize/1024.0);
	}
      }
    } 
    closedir(dir);
    return true;
  }

  bool import(const string &name) {
    bool ok;
    breaked=false;
    size=superGraph->getProperty<MetricProxy>("size");
    uid=superGraph->getProperty<MetricProxy>("uid");
    gid=superGraph->getProperty<MetricProxy>("gid");
    lastaccess=superGraph->getProperty<MetricProxy>("lastaccess");
    lastmodif=superGraph->getProperty<MetricProxy>("lastmodif");
    lastchange=superGraph->getProperty<MetricProxy>("lastchange");
    type=superGraph->getProperty<IntProxy>("viewShape");
    label=superGraph->getProperty<StringProxy>("name");
    type->setAllNodeValue(0);
    node newNode=superGraph->addNode();
    QString dirName=QFileDialog::getExistingDirectory ();
    if (dirName.isNull()) return false;

    struct stat infoEntry;
    lstat(dirName.ascii(),&infoEntry);
    if (infoEntry.st_dev!=true)  {
      label->setNodeValue(newNode,dirName.ascii());
      if (infoEntry.st_size<1)
	size->setNodeValue(newNode,1);
      else
	size->setNodeValue(newNode,infoEntry.st_size);
      uid->setNodeValue(newNode,infoEntry.st_uid);
      gid->setNodeValue(newNode,infoEntry.st_gid);
      lastaccess->setNodeValue(newNode,infoEntry.st_atime);
      lastmodif->setNodeValue(newNode,infoEntry.st_mtime);
      lastchange->setNodeValue(newNode,infoEntry.st_ctime);
    }
    readDir(newNode,string(dirName.ascii())+"/");
    double newSize=0;
    if (!breaked) {
      Iterator<node> *itN=superGraph->getOutNodes(newNode);
      while (itN->hasNext()) {
	node itn=itN->next();
	newSize+=size->getNodeValue(itn);
      } delete itN;
      size->setNodeValue(newNode,newSize);
    }
    return !breaked;
  }
};

IMPORTPLUGIN(FileSystem,"FileSystem","Auber","16/12/2002","0","0","1")
