#include <tulip/MutableContainer.h>
#include "SpringElectrical.h"

LAYOUTPLUGIN(SpringElectrical,"Spring_Electrical","David Auber","14/01/2002","Alpha","0","1");

using namespace std;

inline double sqr(double x) {
  return (x*x);
}

SpringElectrical::SpringElectrical(const PropertyContext &context):Layout(context){
}

SpringElectrical::~SpringElectrical() {
}

bool SpringElectrical::run() {
  double width   = 100;
  double height  = 100;
  double depth   = 100;
  int iterations = superGraph->numberOfNodes();
  LayoutProxy* inputLayout=superGraph->getProperty<LayoutProxy>("viewLayout");
  SelectionProxy* inputSelection=superGraph->getProperty<SelectionProxy>("viewSelection");

  Iterator<node> *itN=superGraph->getNodes();
  while(itN->hasNext()){
    node v=itN->next();
    layoutProxy->setNodeValue(v,inputLayout->getNodeValue(v));
  } delete itN;

  MutableContainer<Coord> disp;
  double k = sqrt(width*height / superGraph->numberOfNodes());
  double kSquare= sqr(k);
  Observable::unholdObservers();
  for (int count = 1; count < iterations; ++count) {
    if (pluginProgress->progress(count,iterations)==false) break;
    float l2 = 50*log(1.0+count)/log(2.0);
    Coord t(width/l2,height/l2,depth/l2);
    disp.setAll(Coord(0,0,0));

    // repulsive forces
    Iterator<node> *itN=superGraph->getNodes();
    while(itN->hasNext()) {
      node v=itN->next();
      if (inputSelection->getNodeValue(v)) continue;
      Coord vCoord = layoutProxy->getNodeValue(v);
      Iterator<node> *itN1 = superGraph->getNodes();
      while(itN1->hasNext()) {
	node u=itN1->next();
	if (u == v) continue;
	Iterator<node> *itN2 = superGraph->getInOutNodes(u);
	while(itN2->hasNext()) {
	  node u=itN2->next();
	  if (u == v) continue;
	  Coord vdist = vCoord-layoutProxy->getNodeValue(u);
	  double dist = vdist*vdist;
	  if (dist < 1e-3) dist = 1e-3;
	  vdist*=kSquare/dist;
	  disp.set(v.id, disp.get(v.id)+vdist);
	  disp.set(u.id, disp.get(u.id)-vdist);
	} delete itN2;
      } delete itN1;
    } delete itN;
     
    // attractive forces
    Iterator<edge> *itE=superGraph->getEdges();
    while(itE->hasNext()) {
      edge e = itE->next();
      node u = superGraph->source(e);
      node v = superGraph->target(e);
      Coord vCoord = layoutProxy->getNodeValue(v);
      Coord uCoord = layoutProxy->getNodeValue(u);
      Coord vdist = vCoord-uCoord;
      double dist = vdist.norm();
      double f = (superGraph->deg(u)+superGraph->deg(v))/16.0;
      dist /= f;
      Coord cV(disp.get(v.id));
      Coord cU(disp.get(u.id));
      vdist *= dist/k;
      cV -= vdist;
      cU += vdist;
      disp.set(v.id,cV);
      disp.set(u.id,cU);
    } delete itE;
   
    // preventions
    itN=superGraph->getNodes();
    while (itN->hasNext()){
      node v = itN->next();
      if (!inputSelection->getNodeValue(v)) {
	Coord d = disp.get(v.id);
	d *= 1.0-((double)count/(double)iterations); // t/d.norm();
	d *= t/d.norm();
	layoutProxy->setNodeValue(v,layoutProxy->getNodeValue(v)+d);
	//disp.set(v.id,Coord(0,0,0));
      }
    } delete itN;
    disp.setAll(Coord(0,0,0));
  }
  return pluginProgress->progress(100,100);
}

bool SpringElectrical::check(string &erreurMsg){
  erreurMsg="";
  return true;
}

void SpringElectrical::reset(){}









