#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tulip/SuperGraph.h>
#include <tulip/LayoutProxy.h>
#include <tulip/SelectionProxy.h>
#include <tulip/GlGraphWidget.h>

#include "MouseMoveSelection.h"

void MouseMoveSelection:: mPressEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv)
{
  switch(qMouseEv->button())
    {
    case QEvent::LeftButton:
      x=qMouseEv->x();
      y=qMouseEv->y();
      break;
    default: break;
    }
}
void MouseMoveSelection:: mReleaseEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv){}
void MouseMoveSelection:: mPaint(GlGraphWidget *){}
void MouseMoveSelection:: mMoveEvent(GlGraphWidget *glGraphWidget,QMouseEvent *qMouseEv) {
  Observable::holdObservers();

  SuperGraph*_superGraph=glGraphWidget->getGlGraph()->getSuperGraph();
  LayoutProxy* mLayout=_superGraph->getProperty<LayoutProxy>("viewLayout");
  SelectionProxy* elementSelected=_superGraph->getProperty<SelectionProxy>("viewSelection");
  
  double x1=0,y1=0,z1=0;
  double x0=0,y0=0,z0=0;

  Coord tmpCoord;
  x1 = (double) (x - qMouseEv->x());
  y1 = -(double) (y - qMouseEv->y());
  x=qMouseEv->x();
  y=qMouseEv->y();
  glGraphWidget->getGlGraph()->screenTo3DWorld(x0,y0,z0);
  glGraphWidget->getGlGraph()->screenTo3DWorld(x1,y1,z1);

  x1-=x0;y1-=y0;z1-=z0;
  Coord translate(x1,y1,z1);
  Iterator<node> *itN=_superGraph->getNodes();
  for (;itN->hasNext();) {
    node itv=itN->next();
    if (elementSelected->getNodeValue(itv) == true) 
      mLayout->setNodeValue(itv, mLayout->getNodeValue(itv)+translate);
  } delete itN;

  Iterator<edge> *itE=_superGraph->getEdges();
  for (;itE->hasNext();) {
    edge ite=itE->next();
    if (elementSelected->getEdgeValue(ite) == true) {
      const LineType::RealType &oldEdgeCoord = mLayout->getEdgeValue(ite);
      if (! oldEdgeCoord.empty() ) {
	LineType::RealType newEdgeCoord;
	LineType::RealType::const_iterator itCoord;
	for (itCoord=oldEdgeCoord.begin();itCoord!=oldEdgeCoord.end();++itCoord) {
	  tmpCoord=*itCoord;
	  tmpCoord+=translate;
	  newEdgeCoord.push_back(tmpCoord);
	}
	//	oldEdgeCoord.clear();
	mLayout->setEdgeValue(ite, newEdgeCoord);
      }
    }
  } delete itE;
  
  glGraphWidget->redraw();
  Observable::unholdObservers();
}
